/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.ExternalIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;

class ExternalDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/ExternalDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("External");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static final String ATTR_ESID = "_esid";
    private static DeserializerIF instance = null;

    ExternalDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new ExternalDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    public void deserialize(Object target, DeserializerTransactionIF ta) {
        throw new RuntimeException("Gotcha!");
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = ta.getXML();
        String clsName = null;
        String esid = null;
        ExternalIF current = null;
        try {
            clsName = rootElem.getAttrString("_type");
            esid = rootElem.getAttrString(ATTR_ESID);
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
        try {
            current = (ExternalIF)SerialToolkit.create(Class.forName(clsName));
        }
        catch (ClassNotFoundException cnfE) {
            throw new SerialException(new JavaException(cnfE));
        }
        try {
            ta.push(rootElem.getElement(esid));
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
        Object obj = current.deserialize(ta);
        ta.pop();
        return obj;
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
    }
}

