/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.serial.AbstractSerializer;
import com.sap.sdt.util.serial.SecurityViolationException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerializationNotSupportedException;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

class DefaultSerializer
extends AbstractSerializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/DefaultSerializer.java#2 $";
    private static final SerialID serialID = new SerialID("Class");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static SerializerIF instance = null;

    DefaultSerializer() {
    }

    public static SerializerIF instance() {
        if (instance == null) {
            instance = new DefaultSerializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected XMLElementIF process(SerializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = this.createRootElem(ta.getCurrent());
        Object obj = ta.getCurrent().getObject();
        if (!(obj instanceof Serializable) && ta.isParanoid()) {
            throw new SerializationNotSupportedException(obj.getClass());
        }
        XMLElementIF subElem = null;
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            if (this.isRegistered(ta, cls)) {
                this.doRegistered(rootElem, ta, cls);
            } else {
                if (this.hasOwnSerialization(cls)) {
                    throw new SerializationNotSupportedException(cls);
                }
                this.doDefault(rootElem, ta, cls);
            }
            if (subElem == null) continue;
            rootElem.add(subElem);
        }
        return rootElem;
    }

    protected boolean hasOwnSerialization(Class cls) throws SerialException {
        boolean hasOwnSerialization = false;
        hasOwnSerialization |= this.hasWriteObject(cls);
        hasOwnSerialization |= this.hasReadObject(cls);
        hasOwnSerialization |= this.hasWriteReplace(cls);
        hasOwnSerialization |= this.hasReadResolve(cls);
        hasOwnSerialization |= this.hasWriteExternal(cls);
        hasOwnSerialization |= this.hasReadObjectNoData(cls);
        return (hasOwnSerialization |= this.hasReadExternal(cls)) && cls != Throwable.class;
    }

    protected boolean hasWriteObject(Class cls) throws SerialException {
        Class[] params = new Class[]{ObjectOutputStream.class};
        return this.hasMethod(cls, "writeObject", params);
    }

    protected boolean hasReadObject(Class cls) throws SerialException {
        Class[] params = new Class[]{ObjectInputStream.class};
        return this.hasMethod(cls, "readObject", params);
    }

    protected boolean hasWriteReplace(Class cls) throws SerialException {
        Class[] params = new Class[]{};
        return this.hasMethod(cls, "writeReplace", params);
    }

    protected boolean hasReadResolve(Class cls) throws SerialException {
        Class[] params = new Class[]{};
        return this.hasMethod(cls, "readResolve", params);
    }

    protected boolean hasWriteExternal(Class cls) throws SerialException {
        Class[] params = new Class[]{ObjectOutput.class};
        return this.hasMethod(cls, "writeExternal", params);
    }

    protected boolean hasReadExternal(Class cls) throws SerialException {
        Class[] params = new Class[]{ObjectInput.class};
        return this.hasMethod(cls, "readExternal", params);
    }

    protected boolean hasReadObjectNoData(Class cls) throws SerialException {
        Class[] params = new Class[]{};
        return this.hasMethod(cls, "readObjectNoData", params);
    }

    protected boolean hasMethod(Class cls, String name, Class[] params) throws SerialException {
        boolean hasMethod = true;
        try {
            cls.getDeclaredMethod(name, params);
        }
        catch (SecurityException sE) {
            throw new SecurityViolationException(new JavaException(sE));
        }
        catch (NoSuchMethodException nsmE) {
            hasMethod = false;
        }
        return hasMethod;
    }

    protected boolean isRegistered(SerializerTransactionIF ta, Class cls) {
        return ta.idIsRegistered(new SerialID(cls.getName()));
    }

    protected void doRegistered(XMLElementIF rootElem, SerializerTransactionIF ta, Class cls) throws SerialException {
        XMLElementIF subElem = ta.process(ta.getCurrent().getObject(), cls);
        if (subElem != null) {
            rootElem.add(subElem);
        }
    }

    protected void doDefault(XMLElementIF rootElem, SerializerTransactionIF ta, Class cls) throws SerialException {
        XMLElementIF subElem = null;
        Object obj = ta.getCurrent().getObject();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!this.isSerializable(obj, fields[i]) || (subElem = ta.process(obj, fields[i])) == null) continue;
            rootElem.add(subElem);
        }
    }

    protected boolean isSerializable(Object obj, Field field) {
        boolean ret = true;
        if (this.isStatic(field) || this.isTransient(field)) {
            ret = false;
        }
        return ret;
    }

    protected boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    protected boolean isTransient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }
}

