/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.Iterator;

class DefaultDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/DefaultDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("Class");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    DefaultDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new DefaultDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = ta.getXML();
        try {
            Class<?> cls = Class.forName(rootElem.getAttrString("_type"));
            return SerialToolkit.create(cls);
        }
        catch (ClassNotFoundException cnfE) {
            throw new SerialException(new JavaException(cnfE));
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
        Iterator rootIter = ta.getXML().getSubElements();
        XMLElementIF subElem = null;
        try {
            while (rootIter.hasNext()) {
                subElem = (XMLElementIF)rootIter.next();
                if (subElem.getAttrString("_name").equals("base")) {
                    this.doRegistered(ta, obj, subElem);
                    continue;
                }
                this.doDefault(ta, obj, subElem);
            }
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, subElem);
        }
    }

    protected void doRegistered(DeserializerTransactionIF ta, Object rootObj, XMLElementIF subElem) throws SerialException {
        ta.process(rootObj, subElem);
    }

    protected void doDefault(DeserializerTransactionIF ta, Object rootObj, XMLElementIF fieldElem) throws SerialException, XMLException {
        Object subObj = ta.process(fieldElem);
        String fieldName = fieldElem.getAttrString("_name");
        SerialToolkit.setValue(rootObj, subObj, fieldName);
    }
}

