/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Date;

class DateSerializer
extends AbstractSerializer {
    private static final SerialID serialID = new SerialID("java.util.Date");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static SerializerIF instance = null;

    DateSerializer() {
    }

    public static SerializerIF instance() {
        if (instance == null) {
            instance = new DateSerializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected XMLElementIF process(SerializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = this.createRootElem(ta.getCurrent());
        Date date = (Date)ta.getCurrent().getObject();
        rootElem.add(this.createValueElem(Long.toString(date.getTime())));
        return rootElem;
    }
}

