/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.Date;

class DateDeserializer
extends AbstractDeserializer {
    private static final SerialID serialID = new SerialID("java.util.Date");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    DateDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new DateDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        return new Date();
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = ta.getXML();
        try {
            Date date = (Date)obj;
            String value = this.getValue(rootElem);
            date.setTime(Long.parseLong(value));
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
    }
}

