/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.lang.reflect.Array;

class ArraySerializer
extends AbstractSerializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/ArraySerializer.java#2 $";
    private static final SerialID serialID = new SerialID("Array");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static final String ATTR_COMP = "_comp";
    private static final String ATTR_LENGTH = "_length";
    private static SerializerIF instance = null;

    ArraySerializer() {
    }

    public static SerializerIF instance() {
        if (instance == null) {
            instance = new ArraySerializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected XMLElementIF process(SerializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = this.createRootElem(ta.getCurrent());
        Object obj = ta.getCurrent().getObject();
        int length = Array.getLength(obj);
        rootElem.setAttr(ATTR_LENGTH, new Integer(length).toString());
        rootElem.setAttr(ATTR_COMP, ta.getCurrent().getCompName());
        for (int i = 0; i < length; ++i) {
            XMLElementIF entry = ta.process(Array.get(obj, i));
            if (entry != null) {
                rootElem.add(entry);
                continue;
            }
            rootElem.add(SerialToolkit.NULL_ELEMENT);
        }
        return rootElem;
    }
}

