/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.lang.reflect.Array;
import java.util.ArrayList;

class ArrayListSerializer
extends AbstractSerializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/ArrayListSerializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.util.ArrayList");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static final String ATTR_LENGTH = "length";
    private static SerializerIF instance = null;

    ArrayListSerializer() {
    }

    public static SerializerIF instance() {
        if (instance == null) {
            instance = new ArrayListSerializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected XMLElementIF process(SerializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = this.createRootElem(ta.getCurrent());
        ArrayList list = (ArrayList)ta.getCurrent().getObject();
        rootElem.setAttr(ATTR_LENGTH, this.getLength(list));
        XMLElementIF valueElem = XMLAdmin.createXMLElement();
        valueElem.setName("_value");
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            XMLElementIF val = ta.process(obj);
            val = val == null ? SerialToolkit.NULL_ELEMENT : val;
            valueElem.add(val);
        }
        rootElem.add(valueElem);
        return rootElem;
    }

    protected String getLength(ArrayList list) throws SerialException {
        int length = Array.getLength(SerialToolkit.getValue(list, "elementData"));
        return Integer.toString(length);
    }
}

