/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;

class ArrayListDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/ArrayListDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.util.ArrayList");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static final String ATTR_LENGTH = "length";
    private static DeserializerIF instance = null;

    ArrayListDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new ArrayListDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    public void deserialize(Object target, DeserializerTransactionIF ta) throws SerialException {
        ArrayList list = (ArrayList)target;
        XMLElementIF rootElem = ta.getXML();
        Object entries = this.createEntries(list, this.getLength(rootElem));
        SerialToolkit.setValue(list, entries, "elementData");
        this.process(list, ta);
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        int initialCapacity = this.getLength(ta.getXML());
        ArrayList list = new ArrayList(initialCapacity);
        return list;
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
        ArrayList list = (ArrayList)obj;
        XMLElementIF rootElem = ta.getXML();
        try {
            ta.register(rootElem.getAttrString("_uid"), list);
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
        XMLElementIF valElem = null;
        try {
            valElem = rootElem.getElement("_value");
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
        Iterator it = valElem.getSubElements();
        while (it.hasNext()) {
            XMLElementIF val = (XMLElementIF)it.next();
            Object valObj = null;
            if (!val.getName().equals("_null")) {
                valObj = ta.process(val);
            }
            list.add(valObj);
        }
    }

    protected int getLength(XMLElementIF elem) throws SerialException {
        try {
            return elem.getAttrInteger(ATTR_LENGTH);
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, elem);
        }
    }

    protected Object createEntries(ArrayList list, int length) throws SerialException {
        Class<?> arrCls = SerialToolkit.getField(list, "elementData").getType();
        return Array.newInstance(arrCls.getComponentType(), length);
    }
}

