/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.TypeMapper;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.lang.reflect.Array;
import java.util.Iterator;

class ArrayDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/ArrayDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("Array");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static final String ATTR_COMP = "_comp";
    private static final String ATTR_LENGTH = "_length";
    private static DeserializerIF instance = null;

    ArrayDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new ArrayDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = ta.getXML();
        try {
            String compName = rootElem.getAttrString(ATTR_COMP);
            int length = rootElem.getAttrInteger(ATTR_LENGTH);
            return this.createArray(compName, length);
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
        Iterator rootIter = ta.getXML().getSubElements();
        int i = 0;
        while (rootIter.hasNext()) {
            XMLElementIF entryElem = (XMLElementIF)rootIter.next();
            if (!entryElem.getName().equals("_null")) {
                Object entry = ta.process(entryElem);
                Array.set(obj, i, entry);
            }
            ++i;
        }
    }

    protected Object createArray(String compName, int length) throws SerialException {
        Object array = null;
        Class<?> cls = null;
        int typeID = TypeMapper.getType(compName);
        switch (typeID) {
            case 2: {
                array = new boolean[length];
                break;
            }
            case 3: {
                array = new char[length];
                break;
            }
            case 4: {
                array = new byte[length];
                break;
            }
            case 5: {
                array = new short[length];
                break;
            }
            case 6: {
                array = new int[length];
                break;
            }
            case 7: {
                array = new long[length];
                break;
            }
            case 8: {
                array = new float[length];
                break;
            }
            case 9: {
                array = new double[length];
                break;
            }
            default: {
                try {
                    cls = Class.forName(compName);
                }
                catch (ClassNotFoundException cnfE) {
                    throw new SerialException(new JavaException(cnfE));
                }
                array = Array.newInstance(cls, length);
            }
        }
        return array;
    }
}

