/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.ReferenceSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialTarget;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerNotFoundException;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.serial.Uid;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public abstract class AbstractSerializerTransaction
implements SerializerTransactionIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/AbstractSerializerTransaction.java#2 $";
    protected boolean isParanoid = false;
    protected Map serializerMap = null;
    protected Map objectMap = null;
    protected Stack targets = null;

    protected AbstractSerializerTransaction() {
        this.serializerMap = new HashMap();
        this.objectMap = new HashMap();
        this.targets = new Stack();
    }

    protected AbstractSerializerTransaction(AbstractSerializerTransaction ta) {
        this.serializerMap = new HashMap(ta.serializerMap);
        this.objectMap = new HashMap();
        this.targets = new Stack();
        this.isParanoid = ta.isParanoid();
    }

    public void setParanoid(boolean isParanoid) {
        this.isParanoid = isParanoid;
    }

    public boolean isParanoid() {
        return this.isParanoid;
    }

    public SerialTarget getCurrent() {
        return (SerialTarget)this.targets.peek();
    }

    public XMLElementIF process(boolean val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(char val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(byte val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(short val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(int val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(long val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(float val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(double val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(Object val) throws SerialException {
        return this.process(new SerialTarget(val));
    }

    public XMLElementIF process(Object val, Field field) throws SerialException {
        return this.process(new SerialTarget(val, field));
    }

    public XMLElementIF process(Object val, Class cls) throws SerialException {
        return this.process(new SerialTarget(val, cls, this.getCurrent().getUid()));
    }

    public boolean idIsRegistered(SerialID id) {
        return this.serializerMap.containsKey(id);
    }

    public SerializerIF getSerializer(SerialTarget target) throws SerialException {
        SerialID id = this.getSerialID(target);
        SerializerIF serializer = null;
        if (!this.idIsRegistered(id)) {
            throw new SerializerNotFoundException(id.getID());
        }
        serializer = (SerializerIF)this.serializerMap.get(id);
        return serializer;
    }

    public void register(SerializerIF serializer) {
        this.serializerMap.put(serializer.getSerialID(), serializer);
    }

    public void register(SerialTarget target) {
        this.objectMap.put(target.getObject(), target.getUid());
    }

    protected XMLElementIF process(SerialTarget target) throws SerialException {
        XMLElementIF rootElem = null;
        if (this.targets.isEmpty()) {
            rootElem = this.createRoot();
            rootElem.add(this.createHeader());
        }
        if (target.isSerializable()) {
            this.targets.push(target);
            if (rootElem != null) {
                rootElem.add(this.getSerializer(target).serialize(this));
            } else {
                rootElem = this.getSerializer(target).serialize(this);
            }
            this.targets.pop();
        }
        return rootElem;
    }

    protected XMLElementIF createRoot() {
        XMLElementIF rootElem = XMLAdmin.createXMLElement();
        rootElem.setName("Transaction");
        return rootElem;
    }

    protected XMLElementIF createHeader() {
        XMLElementIF header = XMLAdmin.createXMLElement();
        header.setName("Header");
        header.setAttr("version", ((Object)this.getVersion()).toString());
        return header;
    }

    protected SerialID getSerialID(SerialTarget target) {
        SerialID id = new SerialID(target.getTypeName());
        if (target.isBaseClass()) {
            return id;
        }
        if (!target.isPrimitive() && this.objectIsRegistered(target.getObject())) {
            Uid uid = (Uid)this.objectMap.get(target.getObject());
            target.setUid(uid);
            return ReferenceSerializer.instance().getSerialID();
        }
        if (this.idIsRegistered(id)) {
            return id;
        }
        return target.getSerialID();
    }

    protected boolean objectIsRegistered(Object obj) {
        Iterator iter = this.objectMap.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (obj != key) continue;
            return true;
        }
        return false;
    }
}

