/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.PrimitiveSerializer;
import com.sap.sdt.util.serial.ReferenceSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialTarget;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;

public abstract class AbstractSerializer
implements SerializerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/AbstractSerializer.java#2 $";

    protected AbstractSerializer() {
    }

    public final XMLElementIF serialize(SerializerTransactionIF ta) throws SerialException {
        if (!this.mustAvoidRegistration()) {
            ta.register(ta.getCurrent());
        }
        return this.process(ta);
    }

    protected abstract XMLElementIF process(SerializerTransactionIF var1) throws SerialException;

    protected XMLElementIF createRootElem(SerialTarget target) {
        XMLElementIF rootElem = XMLAdmin.createXMLElement();
        rootElem.setName(this.getSerialID().getID());
        rootElem.setAttr("_version", ((Object)this.getVersion()).toString());
        rootElem.setAttr("_uid", target.getUid().toString());
        rootElem.setAttr("_name", target.getFieldName());
        rootElem.setAttr("_type", target.getTypeName());
        return rootElem;
    }

    protected XMLElementIF createValueElem(String value) {
        XMLElementIF elem = XMLAdmin.createXMLElement();
        elem.setName("_value");
        elem.setContent(value);
        return elem;
    }

    private boolean mustAvoidRegistration() {
        SerialID pID = PrimitiveSerializer.instance().getSerialID();
        SerialID rID = ReferenceSerializer.instance().getSerialID();
        return this.getSerialID().equals(pID) || this.getSerialID().equals(rID);
    }
}

