/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerNotFoundException;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.ObjectNotFoundException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public abstract class AbstractDeserializerTransaction
implements DeserializerTransactionIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/AbstractDeserializerTransaction.java#2 $";
    protected Map deserializerMap = null;
    protected Map objectMap = null;
    protected Stack targets = null;

    protected AbstractDeserializerTransaction() {
        this.deserializerMap = new HashMap();
        this.objectMap = new HashMap();
        this.targets = new Stack();
    }

    protected AbstractDeserializerTransaction(AbstractDeserializerTransaction ta) {
        this.deserializerMap = new HashMap(ta.deserializerMap);
        this.objectMap = new HashMap();
        this.targets = new Stack();
    }

    public Object process(XMLElementIF rootElem) throws SerialException {
        if (this.targets.isEmpty() && this.readHeader(rootElem)) {
            Iterator it = rootElem.getSubElements();
            it.next();
            rootElem = (XMLElementIF)it.next();
        }
        this.targets.push(rootElem);
        Object obj = this.getDeserializer(rootElem).deserialize(this);
        this.targets.pop();
        return obj;
    }

    public void process(Object target, XMLElementIF rootElem) throws SerialException {
        this.targets.push(rootElem);
        this.getDeserializer(rootElem).deserialize(target, this);
        this.targets.pop();
    }

    public void push(XMLElementIF elem) {
        this.targets.push(elem);
    }

    public void pop() {
        this.targets.pop();
    }

    public XMLElementIF getXML() {
        return (XMLElementIF)this.targets.peek();
    }

    public DeserializerIF getDeserializer(XMLElementIF rootElem) throws SerialException {
        DeserializerIF deserializer = null;
        SerialID id = new SerialID(rootElem.getName());
        if (!this.idIsRegistered(id)) {
            throw new DeserializerNotFoundException(id.getID());
        }
        deserializer = (DeserializerIF)this.deserializerMap.get(id);
        return deserializer;
    }

    public void register(DeserializerIF deserializer) {
        SerialID id = deserializer.getSerialID();
        this.deserializerMap.put(id, deserializer);
    }

    public void register(String uid, Object obj) {
        this.objectMap.put(uid, obj);
    }

    public Object getObjectByUid(String uid) throws SerialException {
        Iterator iter = this.objectMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!uid.equals(key)) continue;
            return this.objectMap.get(uid);
        }
        throw new ObjectNotFoundException(uid);
    }

    protected boolean readHeader(XMLElementIF rootElem) {
        boolean hasHeader = true;
        try {
            rootElem.getElement("Header");
        }
        catch (XMLException xmlE) {
            hasHeader = false;
        }
        return hasHeader;
    }

    protected boolean idIsRegistered(SerialID id) {
        return this.deserializerMap.containsKey(id);
    }

    protected boolean objectIsRegistered(String uid) {
        return this.objectMap.containsKey(uid);
    }
}

