/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.InvalidBaseClassException;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.PrimitiveDeserializer;
import com.sap.sdt.util.serial.ReferenceDeserializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;

public abstract class AbstractDeserializer
implements DeserializerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/AbstractDeserializer.java#2 $";
    private static final String DEPRECATED_ATTR_VALUE = "_value";

    protected AbstractDeserializer() {
    }

    public final Object deserialize(DeserializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = ta.getXML();
        Object obj = this.createObject(ta);
        if (!this.mustAvoidRegistration()) {
            try {
                ta.register(rootElem.getAttrString("_uid"), obj);
            }
            catch (XMLException xmlE) {
                throw new MalformedElementException(xmlE, rootElem);
            }
        }
        this.process(obj, ta);
        return obj;
    }

    public void deserialize(Object target, DeserializerTransactionIF ta) throws SerialException {
        throw new InvalidBaseClassException(this.getSerialID());
    }

    protected abstract Object createObject(DeserializerTransactionIF var1) throws SerialException;

    protected abstract void process(Object var1, DeserializerTransactionIF var2) throws SerialException;

    protected String getValue(XMLElementIF elem) throws XMLException {
        String value = null;
        try {
            elem.getAttrString("_version");
            value = elem.getElement(DEPRECATED_ATTR_VALUE).getContent();
        }
        catch (XMLException xmlE) {
            value = elem.getAttrString(DEPRECATED_ATTR_VALUE);
        }
        return value;
    }

    private boolean mustAvoidRegistration() {
        SerialID pID = PrimitiveDeserializer.instance().getSerialID();
        SerialID rID = ReferenceDeserializer.instance().getSerialID();
        return this.getSerialID().equals(pID) || this.getSerialID().equals(rID);
    }
}

