/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.prop;

import com.sap.sdt.util.info.InfoProviderIF;
import com.sap.sdt.util.prop.FactoryPropertiesIF;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public abstract class AbstractFactoryProperties
implements FactoryPropertiesIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/prop/AbstractFactoryProperties.java#2 $";
    public static final String ROOT_DIRECTORY = "rootDirectory";
    protected String name;
    protected Map properties = new TreeMap();
    protected Map defaultProperties = new TreeMap();

    protected AbstractFactoryProperties() {
        this(null);
    }

    protected AbstractFactoryProperties(String name) {
        this.name = name;
        this.defaultProperties.put(ROOT_DIRECTORY, ".");
    }

    public String getName() {
        return this.name;
    }

    public String[] getKeys() {
        return this.defaultProperties.keySet().toArray(new String[0]);
    }

    public final String getProperty(String key) {
        if (this.properties.containsKey(key)) {
            return (String)this.properties.get(key);
        }
        return (String)this.defaultProperties.get(key);
    }

    public final boolean hasProperty(String key) {
        return this.defaultProperties.containsKey(key);
    }

    protected final boolean removeProperty(String key) {
        return this.properties.remove(key) != null;
    }

    public boolean setProperty(String key, String value) {
        if (this.defaultProperties.containsKey(key)) {
            this.properties.put(key, value);
            return true;
        }
        return false;
    }

    public final void load(InfoProviderIF infoProvider, String prefix) {
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String value = infoProvider.get(prefix + keys[i]);
            if (value == null) continue;
            this.setProperty(keys[i], value);
        }
    }

    public final void load(Properties prop, String prefix) {
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String value = prop.getProperty(prefix + keys[i]);
            if (value == null) continue;
            this.setProperty(keys[i], value);
        }
    }

    public File getRootDirectory() {
        return new File(this.getProperty(ROOT_DIRECTORY));
    }

    public void setRootDirectory(File dir) {
        this.setRootDirectory(dir.getAbsolutePath());
    }

    public void setRootDirectory(String dir) {
        this.setProperty(ROOT_DIRECTORY, dir);
    }
}

