/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.Calculator;
import com.sap.sdt.util.parse.MacroProviderIF;
import com.sap.sdt.util.parse.MacroReader;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParseTraceIF;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.XMLIllegalConditionException;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLElementProcessorIF;
import java.util.Iterator;

class XMLConditionParser
implements XMLElementProcessorIF,
MsgIdConstants,
ParseTraceIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/XMLConditionParser.java#2 $";
    private static final String XMLTAGNAME_IF = "if";
    private static final String XMLTAGNAME_CHOOSE = "choose";
    private static final String XMLTAGNAME_WHEN = "when";
    private static final String XMLTAGNAME_OTHERWISE = "otherwise";
    private static final String XMLTAGNAME_FOREACH = "for-each";
    private static final String XMLATTRNAME_TEST = "test";
    private static final String XMLATTRNAME_LOOPVARIABLE = "variable";
    private static final String XMLATTRNAME_LOOPINTO = "into";
    private static final char LOOPINTO_SEPARATOR = '@';
    private MacroProviderIF globalMacHandler;
    private boolean macroProcessing;
    private boolean checkSyntax = true;

    public XMLConditionParser(MacroProviderIF macHandler) {
        this(macHandler, true);
    }

    public XMLConditionParser(MacroProviderIF macHandler, boolean macroProcessing) {
        this.globalMacHandler = macHandler;
        this.macroProcessing = macroProcessing;
    }

    public void setCheckSyntax(boolean checkSyntax) {
        this.checkSyntax = checkSyntax;
    }

    public boolean getCheckSyntax() {
        return this.checkSyntax;
    }

    public XMLElementIF process(XMLElementIF element) throws ParserException {
        return this.process(element, this.globalMacHandler);
    }

    private XMLElementIF process(XMLElementIF element, MacroProviderIF macHandler) throws ParserException {
        XMLElementIF result = this.duplicate0(element, macHandler);
        this.addChildren(element, result, macHandler);
        return result;
    }

    private void addChildren(XMLElementIF element, XMLElementIF father, MacroProviderIF macHandler) throws ParserException {
        Iterator it = element.getSubElements();
        while (it.hasNext()) {
            XMLElementIF sub = (XMLElementIF)it.next();
            this.addChild(sub, father, macHandler);
        }
    }

    private void addChildrenCont(XMLElementIF element, XMLElementIF father, MacroProviderIF macHandler) throws ParserException {
        this.addChildren(element, father, macHandler);
        String content = element.getContent();
        if (content != null) {
            if (this.macroProcessing) {
                content = this.substitute(content, macHandler);
            }
            father.addContent(content);
        }
    }

    private void addChild(XMLElementIF element, XMLElementIF father, MacroProviderIF macHandler) throws ParserException {
        String name = element.getName();
        if (name.equals(XMLTAGNAME_IF)) {
            if (this.checkCondition(element, macHandler)) {
                this.addChildrenCont(element, father, macHandler);
            }
        } else if (name.equals(XMLTAGNAME_CHOOSE)) {
            this.processChoose(element, father, macHandler);
        } else if (name.equals(XMLTAGNAME_FOREACH)) {
            this.processLoop(element, father, macHandler);
        } else {
            element = this.process(element, macHandler);
            father.add(element);
        }
    }

    private void processChoose(XMLElementIF element, XMLElementIF father, MacroProviderIF macHandler) throws ParserException {
        boolean operate = true;
        Iterator it = element.getSubElements();
        while (it.hasNext()) {
            XMLElementIF sub2 = (XMLElementIF)it.next();
            String name = sub2.getName();
            if (name.equals(XMLTAGNAME_WHEN)) {
                if (!operate || !this.checkCondition(sub2, macHandler)) continue;
                this.addChildrenCont(sub2, father, macHandler);
                operate = false;
                continue;
            }
            if (name.equals(XMLTAGNAME_OTHERWISE)) {
                if (operate) {
                    this.addChildrenCont(sub2, father, macHandler);
                }
                if (!it.hasNext()) continue;
                throw new XMLIllegalConditionException("msg.parse.0062");
            }
            throw new XMLIllegalConditionException("msg.parse.0060", name);
        }
    }

    private void processLoop(XMLElementIF element, XMLElementIF father, MacroProviderIF macHandler) throws ParserException {
        MacroProviderIF.MacroIteratorIF loopIterator;
        String looptable = element.getAttrStringNull(XMLATTRNAME_LOOPVARIABLE);
        try {
            loopIterator = macHandler.getValues(looptable);
        }
        catch (DiagException e) {
            throw new ParserException(e);
        }
        String loopvar = element.getAttrStringNull(XMLATTRNAME_LOOPINTO);
        String loopcond = element.getAttrStringNull(XMLATTRNAME_TEST);
        while (loopIterator.hasNext()) {
            MacroProviderIF localHandler = loopIterator.next();
            MacroDelegator currHandler = new MacroDelegator(localHandler, loopvar, macHandler);
            if (loopcond != null && !this.checkCondition(loopcond, (MacroProviderIF)currHandler)) continue;
            this.addChildrenCont(element, father, currHandler);
        }
    }

    private XMLElementIF duplicate0(XMLElementIF element, MacroProviderIF macHandler) throws ParserException {
        XMLElementIF result = XMLAdmin.createXMLElement();
        result.setName(element.getName());
        String value = element.getContent();
        if (value != null && this.macroProcessing) {
            value = this.substitute(value, macHandler);
        }
        result.setContent(value);
        Iterator it = element.getAttrNames();
        while (it.hasNext()) {
            String attrName = (String)it.next();
            value = element.getAttrStringNull(attrName);
            if (value != null && this.macroProcessing) {
                value = this.substitute(value, macHandler);
            }
            result.setAttr(attrName, value);
        }
        return result;
    }

    private boolean checkCondition(XMLElementIF element, MacroProviderIF macHandler) throws ParserException {
        String condition = element.getAttrStringNull(XMLATTRNAME_TEST);
        if (condition == null) {
            throw new XMLIllegalConditionException("msg.parse.0060");
        }
        return this.checkCondition(condition, macHandler);
    }

    private boolean checkCondition(String condition, MacroProviderIF macHandler) throws ParserException {
        condition = this.substitute(condition, macHandler);
        return Calculator.getCalculator().evaluateBoolean(condition);
    }

    private String substitute(String input, MacroProviderIF macHandler) throws ParserException {
        return MacroReader.substitute(input, macHandler, this.checkSyntax);
    }

    private static class MacroDelegator
    implements MacroProviderIF {
        private MacroProviderIF localHandler;
        private MacroProviderIF parent;
        private String varName;

        public MacroDelegator(MacroProviderIF localHandler, String varName, MacroProviderIF parent) {
            this.localHandler = localHandler;
            this.varName = varName + '@';
            this.parent = parent;
        }

        public String getValue(String name, String[] args) throws DiagException {
            String trailer = this.getTrailer(name);
            if (trailer != null) {
                return this.localHandler.getValue(trailer, args);
            }
            return this.parent.getValue(name, args);
        }

        public String hasArguments(String name) throws DiagException {
            String trailer = this.getTrailer(name);
            if (trailer != null) {
                return this.localHandler.hasArguments(trailer);
            }
            return this.parent.hasArguments(name);
        }

        public boolean expandRecursively(String name) throws DiagException {
            String trailer = this.getTrailer(name);
            if (trailer != null) {
                return this.localHandler.expandRecursively(trailer);
            }
            return this.parent.expandRecursively(name);
        }

        public MacroProviderIF.MacroIteratorIF getValues(String name) throws DiagException {
            String trailer = this.getTrailer(name);
            if (trailer != null) {
                return this.localHandler.getValues(trailer);
            }
            return this.parent.getValues(name);
        }

        private String getTrailer(String name) {
            if (!name.startsWith(this.varName)) {
                return null;
            }
            name = name.substring(this.varName.length());
            return name;
        }
    }
}

