/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.IdentToken;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.SimpleTokenReader;
import com.sap.sdt.util.parse.StringToken;
import com.sap.sdt.util.parse.TokenIF;
import com.sap.sdt.util.parse.TokenMatcherIF;
import com.sap.sdt.util.parse.TokenReaderFactory;
import java.util.HashMap;
import java.util.Iterator;

public class VariableSubstitutor
implements TokenMatcherIF,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/VariableSubstitutor.java#2 $";
    private HashMap varmap = new HashMap();

    public VariableSubstitutor() {
    }

    public VariableSubstitutor(HashMap map) throws ParserException {
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = (String)map.get(name);
            this.put(name, value);
        }
    }

    public void put(String name, String value) throws ParserException {
        TokenIF[] tokens = TokenReaderFactory.parse(value);
        this.put(name, tokens);
    }

    public void putString(String name, String value) throws ParserException {
        TokenIF[] tokens = new TokenIF[]{new StringToken(value, true)};
        this.put(name, tokens);
    }

    public void put(String name, TokenIF[] tokens) throws ParserException {
        if (!SimpleTokenReader.isIdentifier(name)) {
            throw new ParserException("msg.parse.0026", name);
        }
        this.varmap.put(name, tokens);
    }

    public void reset() {
    }

    public int matches(TokenIF[] tokens, int n) throws DiagException {
        String name;
        if (n == 1 && tokens[0] instanceof IdentToken && this.varmap.get(name = ((Object)tokens[0]).toString()) != null) {
            return n;
        }
        return 0;
    }

    public TokenIF[] getSubstitute(TokenIF[] tokens, int n) throws DiagException {
        String name = ((Object)tokens[0]).toString();
        Object value = this.varmap.get(name);
        return (TokenIF[])value;
    }
}

