/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.PatternTokenReader;
import com.sap.sdt.util.parse.SimpleTokenReader;
import com.sap.sdt.util.parse.TokenIF;
import com.sap.sdt.util.parse.TokenMatcherIF;
import com.sap.sdt.util.parse.TokenReaderIF;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class TokenReaderFactory {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/TokenReaderFactory.java#2 $";

    public static TokenReaderIF getTokenReader(InputStream in) throws ParserException {
        return TokenReaderFactory.getTokenReader(new InputStreamReader(in), null);
    }

    public static TokenReaderIF getTokenReader(Reader reader) throws ParserException {
        return TokenReaderFactory.getTokenReader(reader, null);
    }

    public static TokenReaderIF getTokenReader(InputStream in, TokenMatcherIF pattMatch) throws ParserException {
        return TokenReaderFactory.getTokenReader(new InputStreamReader(in), pattMatch);
    }

    public static TokenReaderIF getTokenReader(Reader reader, TokenMatcherIF pattMatch) throws ParserException {
        MsgIdConstants tokReader = new SimpleTokenReader(reader);
        if (pattMatch != null) {
            tokReader = new PatternTokenReader((TokenReaderIF)((Object)tokReader), pattMatch);
        }
        return tokReader;
    }

    public static TokenIF[] parse(String string) throws ParserException {
        return TokenReaderFactory.parse(string, false);
    }

    public static TokenIF[] parse(String string, boolean ignwhitespace) throws ParserException {
        return TokenReaderFactory.parse(new StringReader(string), ignwhitespace);
    }

    public static TokenIF[] parse(Reader reader) throws ParserException {
        return TokenReaderFactory.parse(reader, false);
    }

    public static TokenIF[] parse(Reader reader, boolean ignwhitespace) throws ParserException {
        SimpleTokenReader tokReader = new SimpleTokenReader(reader);
        tokReader.setIgnoreWhiteSpace(ignwhitespace);
        ArrayList<TokenIF> alist = new ArrayList<TokenIF>();
        try {
            TokenIF token;
            while ((token = tokReader.getToken()) != null) {
                alist.add(token);
            }
            tokReader.close();
        }
        catch (DiagException e) {
            throw new ParserException(e);
        }
        return alist.toArray(new TokenIF[alist.size()]);
    }
}

