/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.CharMatcherIF;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.value.table.StringTable;
import com.sap.sdt.util.value.table.StringTableRowIF;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class StringReplacer
implements CharMatcherIF,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/StringReplacer.java#2 $";
    private Pair[] storage;
    private int start;
    private int end;

    public StringReplacer(StringTable table) throws ParserException {
        if (table.getNumberKeyColumns() != 1 || table.getNumberColumns() < 2) {
            throw new ParserException("msg.parse.0080");
        }
        int oldIndex = 0;
        int newIndex = 1;
        this.createStorage(table.size());
        StringTable.StringRowIterator it = table.stringRowIterator();
        int i = 0;
        while (it.hasNext()) {
            StringTableRowIF row = it.next();
            this.putPair(i, row.getString(oldIndex), row.getString(newIndex));
            ++i;
        }
        this.initialize();
    }

    public StringReplacer(Map map) {
        this.createStorage(map.size());
        Iterator it = map.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)map.get(key);
            this.putPair(i, key, value);
            ++i;
        }
        this.initialize();
    }

    private void createStorage(int size) {
        this.storage = new Pair[size];
    }

    private void putPair(int index, String key, String value) {
        this.storage[index] = new Pair(key, value);
    }

    private void initialize() {
        Arrays.sort(this.storage);
        this.reset();
    }

    public void reset() {
        this.start = 0;
        this.end = this.storage.length;
    }

    public int matches(String string) throws DiagException {
        int newStart = this.locateKey(string, false);
        int newEnd = this.locateKey(string, true);
        int len = string.length();
        if (newStart == newEnd) {
            if (len > 1 && this.storage[this.start].key.length() == --len) {
                return len;
            }
            return 0;
        }
        if (this.start + 1 == this.end && len == this.storage[this.start].key.length()) {
            return len;
        }
        this.start = newStart;
        this.end = newEnd;
        return -1;
    }

    public String getSubstitute(String string) throws DiagException {
        return this.storage[this.start].getValue();
    }

    public boolean expandRecursive(String string) {
        return false;
    }

    private int locateKey(String key, boolean findrightpos) {
        int lower = this.start;
        int upper = this.end;
        while (lower < upper) {
            int m = lower + upper >> 1;
            int cmp = StringReplacer.compareStart(key, this.storage[m].key);
            if (cmp > 0 || findrightpos && cmp == 0) {
                lower = m + 1;
                continue;
            }
            upper = m;
        }
        return lower;
    }

    private static int compareStart(String key, String other) {
        int olen;
        int minlen;
        int klen = key.length();
        int n = minlen = klen < (olen = other.length()) ? klen : olen;
        if (olen > klen) {
            olen = klen;
        }
        for (int i = 0; i < minlen; ++i) {
            char ochar;
            char kchar = key.charAt(i);
            if (kchar == (ochar = other.charAt(i))) continue;
            return kchar - ochar;
        }
        return klen - olen;
    }

    private static class Pair
    implements Comparable {
        protected String key;
        protected String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int compareTo(Object o) {
            return this.key.compareTo(((Pair)o).key);
        }
    }
}

