/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.parse.BooleanToken;
import com.sap.sdt.util.parse.CharToken;
import com.sap.sdt.util.parse.CommentToken;
import com.sap.sdt.util.parse.IdentToken;
import com.sap.sdt.util.parse.IntNumberToken;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.NumberToken;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.SpaceToken;
import com.sap.sdt.util.parse.StringToken;
import com.sap.sdt.util.parse.TokenIF;
import com.sap.sdt.util.parse.TokenReaderIF;
import java.io.IOException;
import java.io.Reader;

class SimpleTokenReader
implements TokenReaderIF,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/SimpleTokenReader.java#2 $";
    private Reader reader;
    private boolean ignwhitespace = false;
    private boolean recognizecomments = false;
    private boolean booleantoken = false;
    private boolean javastrings = false;
    private StringBuffer strbuffer = new StringBuffer(128);
    private TokenIF ungettok = null;
    private int unget = -1;

    public SimpleTokenReader(Reader reader) {
        this.reader = reader;
    }

    public void close() throws DiagException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new ParserException("msg.parse.0038", new FileIOException(e));
        }
    }

    public void setIgnoreWhiteSpace(boolean ignwhitespace) {
        this.ignwhitespace = ignwhitespace;
    }

    public void setRecognizeComments(boolean recognizecomments) {
        this.recognizecomments = recognizecomments;
    }

    public void setReadBooleanToken(boolean booleantoken) {
        this.booleantoken = booleantoken;
    }

    public void setJavaStrings(boolean javastrings) {
        this.javastrings = javastrings;
    }

    public void unGetToken(TokenIF token) throws DiagException {
        if (this.ungettok != null) {
            throw new ParserException("msg.parse.0020");
        }
        this.ungettok = token;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TokenIF getToken() throws DiagException {
        int c;
        if (this.ungettok != null) {
            TokenIF tok = this.ungettok;
            this.ungettok = null;
            return tok;
        }
        this.strbuffer.delete(0, this.strbuffer.length());
        int state = 0;
        block17: while (true) {
            c = this.read();
            switch (state) {
                case 0: {
                    if (c == -1) break block17;
                    if (Character.isWhitespace((char)c)) {
                        if (this.ignwhitespace) continue block17;
                        state = 2;
                        break;
                    }
                    if (Character.isJavaIdentifierStart((char)c)) {
                        state = 10;
                        break;
                    }
                    if (c == 34) {
                        state = 20;
                        continue block17;
                    }
                    if (c == 39) {
                        state = 30;
                        continue block17;
                    }
                    if (Character.isDigit((char)c)) {
                        state = 40;
                        break;
                    }
                    if (!this.recognizecomments || c != 47) break block17;
                    state = 5;
                    continue block17;
                }
                case 2: {
                    if (c != -1 && Character.isWhitespace((char)c)) break;
                    this.ungetchar(c);
                    return new SpaceToken(this.strbuffer.toString());
                }
                case 5: {
                    if (c == 47) {
                        state = 6;
                        continue block17;
                    }
                    if (c == 42) {
                        state = 7;
                        continue block17;
                    }
                    this.ungetchar(c);
                    c = 47;
                    break block17;
                }
                case 6: {
                    if (c != -1 && c != 10) break;
                    return new CommentToken(this.strbuffer.toString(), true);
                }
                case 7: {
                    if (c == -1) {
                        throw new ParserException("msg.parse.0024");
                    }
                    if (c != 42) break;
                    state = 8;
                    continue block17;
                }
                case 8: {
                    if (c == 47) {
                        return new CommentToken(this.strbuffer.toString(), false);
                    }
                    this.strbuffer.append('*');
                    if (c == 42) continue block17;
                    state = 7;
                    break;
                }
                case 10: {
                    if (c != -1 && Character.isJavaIdentifierPart((char)c)) break;
                    this.ungetchar(c);
                    String ident = this.strbuffer.toString();
                    if (this.booleantoken) {
                        if (ident.equals("true")) {
                            return new BooleanToken(true);
                        }
                        if (ident.equals("false")) {
                            return new BooleanToken(false);
                        }
                    }
                    return new IdentToken(ident);
                }
                case 20: {
                    if (c == 92) {
                        state = 21;
                        continue block17;
                    }
                    if (c == 34) {
                        return new StringToken(this.strbuffer.toString(), true);
                    }
                    if (c != -1 && c != 10) break;
                    throw new ParserException("msg.parse.0021");
                }
                case 21: 
                case 31: {
                    c = this.getEscapeChar(c);
                    --state;
                    break;
                }
                case 30: {
                    if (this.javastrings && c == 92) {
                        state = 31;
                        continue block17;
                    }
                    if (c == 39) {
                        return new StringToken(this.strbuffer.toString(), false);
                    }
                    if (c != -1) break;
                    throw new ParserException("msg.parse.0021");
                }
                case 40: {
                    if (c == 46) {
                        state = 41;
                        break;
                    }
                    if (c == 69) {
                        state = 42;
                        break;
                    }
                    if (c != -1 && Character.isDigit((char)c)) break;
                    this.ungetchar(c);
                    return new IntNumberToken(this.strbuffer.toString());
                }
                case 41: {
                    if (c == 69) {
                        state = 45;
                        break;
                    }
                    if (c != -1 && Character.isDigit((char)c)) break;
                    this.ungetchar(c);
                    return new NumberToken(this.strbuffer.toString());
                }
                case 42: {
                    if (c == -1 || !Character.isDigit((char)c)) break block17;
                    state = 41;
                    break;
                }
                case 45: {
                    if (c != 43 && c != 45 && !Character.isDigit((char)c)) {
                        throw new ParserException("msg.parse.0023", this.strbuffer.toString() + (char)c);
                    }
                    state = 46;
                    break;
                }
                case 46: {
                    if (c != -1 && Character.isDigit((char)c)) break;
                    this.ungetchar(c);
                    return new NumberToken(this.strbuffer.toString());
                }
            }
            if (c == -1) continue;
            this.strbuffer.append((char)c);
        }
        if (c == -1) {
            return null;
        }
        return new CharToken((char)c);
    }

    private int getEscapeChar(int c) throws ParserException {
        if (c == 10) {
            throw new ParserException("msg.parse.0022");
        }
        int ind = "btnfr\"'\\".indexOf((char)c);
        if (ind < 0) {
            throw new ParserException("msg.parse.0025", "\\" + c);
        }
        return "\b\t\n\f\r\"'\\".charAt(ind);
    }

    private void ungetchar(int c) {
        this.unget = c;
    }

    private int read() throws ParserException {
        if (this.unget != -1) {
            int c = this.unget;
            this.unget = -1;
            return c;
        }
        try {
            return this.reader.read();
        }
        catch (IOException e) {
            throw new ParserException("msg.parse.0038", new FileIOException(e));
        }
    }

    public static boolean isIdentifier(String string) {
        int len = string.length();
        if (len > 0 && !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

