/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.AbstractMacroProvider;
import com.sap.sdt.util.parse.MacroReader;
import com.sap.sdt.util.parse.ParserException;

public class Replacer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/Replacer.java#2 $";

    public static String replaceSloppy(String src, String[] params) {
        try {
            return Replacer.replace(src, params, false);
        }
        catch (ParserException e) {
            return src;
        }
    }

    public static String replace(String src, String[] params, boolean checkSyntax) throws ParserException {
        if (src == null) {
            return null;
        }
        StringMacroReplacer macHandler = new StringMacroReplacer(params);
        return MacroReader.substitute(src, macHandler, checkSyntax);
    }

    public static String replaceSloppy(String src, String param) {
        return Replacer.replaceSloppy(src, new String[]{param});
    }

    private static class InvalidReplacerMacroException
    extends DiagException {
        public InvalidReplacerMacroException(String string) {
            super(string);
        }
    }

    private static class StringMacroReplacer
    extends AbstractMacroProvider {
        private String[] strings;

        public StringMacroReplacer(String[] strings) {
            this.strings = strings;
        }

        public String getValue(String name, String[] args) throws DiagException {
            try {
                int pos = Integer.parseInt(name);
                if (pos < 0 || pos >= this.strings.length) {
                    throw new InvalidReplacerMacroException(name);
                }
                String result = this.strings[pos];
                if (result == null) {
                    return "null";
                }
                return result;
            }
            catch (NumberFormatException e) {
                throw new InvalidReplacerMacroException(name);
            }
        }

        public String hasArguments(String name) {
            return null;
        }

        public boolean expandRecursively(String name) {
            return false;
        }
    }
}

