/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;
import java.util.Stack;

class PreProcStack
extends Stack
implements MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/PreProcStack.java#2 $";
    public static final int PPLINE_IF = 1;
    public static final int PPLINE_ELSE = 2;
    public static final int PPLINE_ELSEIF = 3;
    public static final int PPLINE_ENDIF = 4;

    public void handleLine(int type, boolean value) throws ParserException {
        IfLevel top;
        IfLevel ifLevel = top = this.isEmpty() ? null : (IfLevel)this.peek();
        if (type == 1) {
            this.push(new IfLevel(top, value));
            return;
        }
        if (top == null) {
            throw new ParserException("msg.parse.0070");
        }
        if (type == 2 || type == 3) {
            if (top.hasSeenElse()) {
                throw new ParserException("msg.parse.0071");
            }
            if (type == 2) {
                top.didSeeElse();
            }
            if (top.isVisible()) {
                if (top.isEnabled()) {
                    top.makeInvisible();
                } else if (type == 2 || value) {
                    top.enable();
                }
            }
        } else if (type == 4) {
            this.pop();
        }
    }

    public boolean isOutput() {
        if (this.isEmpty()) {
            return true;
        }
        IfLevel top = (IfLevel)this.peek();
        return top.isOutput();
    }

    public boolean canBeTrue() {
        if (this.isEmpty()) {
            return true;
        }
        IfLevel top = (IfLevel)this.peek();
        return top.isVisible() && !top.isEnabled();
    }

    private static class IfLevel {
        private boolean visible;
        private boolean enabled;
        private boolean elseseen = false;

        IfLevel(IfLevel old, boolean enabled) {
            this.visible = old == null || old.isOutput();
            this.enabled = enabled;
        }

        boolean isVisible() {
            return this.visible;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        boolean isOutput() {
            return this.visible && this.enabled;
        }

        boolean hasSeenElse() {
            return this.elseseen;
        }

        void makeInvisible() {
            this.visible = false;
        }

        void enable() {
            this.enabled = true;
        }

        void didSeeElse() {
            this.elseseen = true;
        }
    }
}

