/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.diag.WrapperIOException;
import com.sap.sdt.util.parse.Calculator;
import com.sap.sdt.util.parse.MacroProviderIF;
import com.sap.sdt.util.parse.MacroReader;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.PreProcStack;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;

public class PreProcReader
extends MacroReader {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/PreProcReader.java#2 $";
    public static final int DEFAULT_LINEMODE = 1;
    private LineNumberReader lineReader = null;
    private boolean removeComments = true;
    private int lineMode;
    private static final char PREPROC_START = '#';
    private static final String PPLINE_IF = "if";
    private static final String PPLINE_ELSE = "else";
    private static final String PPLINE_ELIF = "elif";
    private static final String PPLINE_ELIF2 = "elseif";
    private static final String PPLINE_ENDIF = "endif";
    private int lastchar = 10;
    private StringBuffer strbuffer = new StringBuffer();
    private PreProcStack ppstack = new PreProcStack();

    public PreProcReader(String fileName, MacroProviderIF macHandler) throws SDTFileNotFoundException {
        this(fileName, macHandler, 1);
    }

    public PreProcReader(String fileName, MacroProviderIF macHandler, int lineMode) throws SDTFileNotFoundException {
        super(macHandler);
        try {
            this.lineReader = new LineNumberReader(new FileReader(fileName));
            this.open(this.lineReader);
        }
        catch (FileNotFoundException e) {
            throw new SDTFileNotFoundException(fileName);
        }
        this.setLineMode(lineMode);
    }

    public PreProcReader(InputStream in, MacroProviderIF macHandler) {
        this(in, macHandler, 1);
    }

    public PreProcReader(InputStream in, MacroProviderIF macHandler, int lineMode) {
        this(new InputStreamReader(in), macHandler, lineMode);
    }

    public PreProcReader(Reader reader, MacroProviderIF macHandler) {
        this(reader, macHandler, 1);
    }

    public PreProcReader(Reader reader, MacroProviderIF macHandler, int lineMode) {
        super(reader, macHandler);
        if (reader instanceof LineNumberReader) {
            this.lineReader = (LineNumberReader)reader;
        }
        this.setLineMode(lineMode);
    }

    public void setRemoveComments(boolean removeComments) {
        this.removeComments = removeComments;
    }

    public boolean getRemoveComments() {
        return this.removeComments;
    }

    public void setLineMode(int lineMode) {
        this.lineMode = lineMode;
    }

    public int getLineMode() {
        return this.lineMode;
    }

    public String readLine() throws ParserException, FileIOException {
        int c;
        StringBuffer sbuff = new StringBuffer();
        try {
            while ((c = this.read()) != -1 && c != 10) {
                sbuff.append((char)c);
            }
        }
        catch (WrapperIOException e) {
            throw e.getParserException();
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
        if (c == -1 && sbuff.length() == 0) {
            return null;
        }
        return sbuff.toString();
    }

    public int getLineNumber() {
        if (this.lineReader == null) {
            return 0;
        }
        return this.lineReader.getLineNumber();
    }

    public void close() throws IOException {
        super.close();
        this.lineReader = null;
        this.strbuffer = null;
        this.ppstack = null;
    }

    public int read() throws IOException {
        try {
            return this.doRead();
        }
        catch (ParserException e) {
            throw new WrapperIOException(e);
        }
    }

    private int doRead() throws ParserException, IOException {
        int c;
        while ((c = super.read()) != -1) {
            boolean isppline = false;
            if (this.lastchar == 10 && c == 35 && (c = this.doPreProcLine()) != 35) {
                isppline = true;
            }
            if ((this.ppstack.isOutput() && !isppline || c == 10 && this.lineMode < 1) && (this.lineMode < 2 || this.lastchar != 10 || c != 10)) break;
            this.lastchar = c;
        }
        this.lastchar = c;
        return c;
    }

    /*
     * WARNING - void declaration
     */
    private int doPreProcLine() throws IOException, ParserException {
        void var4_4;
        int type;
        int c;
        this.strbuffer.delete(0, this.strbuffer.length());
        int i = 0;
        while ((c = super.read()) != -1 && Character.isJavaIdentifierStart((char)c)) {
            this.strbuffer.append((char)c);
            ++i;
        }
        if (c != -1) {
            this.unGetChar(c);
        }
        if (i == 0) {
            if (!this.removeComments) {
                return 35;
            }
            while ((c = super.read()) != -1 && c != 10) {
            }
            return c;
        }
        String ppcmd = this.strbuffer.toString();
        if (ppcmd.equals(PPLINE_IF)) {
            type = 1;
        } else if (ppcmd.equals(PPLINE_ELSE)) {
            type = 2;
        } else if (ppcmd.equals(PPLINE_ELIF) || ppcmd.equals(PPLINE_ELIF2)) {
            type = 3;
        } else if (ppcmd.equals(PPLINE_ENDIF)) {
            type = 4;
        } else {
            if (!this.removeComments) {
                this.pushString(ppcmd);
                return 35;
            }
            while ((c = super.read()) != -1 && c != 10) {
            }
            return c;
        }
        boolean value = false;
        if ((var4_4 == true || var4_4 == 3) && this.ppstack.canBeTrue()) {
            this.strbuffer.delete(0, this.strbuffer.length());
            while ((c = super.read()) != -1 && c != 10) {
                this.strbuffer.append((char)c);
            }
            String expr = this.strbuffer.toString();
            trc.debug(this.getClass(), "Expression '" + expr + "'");
            value = Calculator.getCalculator().evaluateBoolean(expr);
        } else {
            while ((c = super.read()) != -1 && c != 10) {
            }
        }
        this.ppstack.handleLine((int)var4_4, value);
        return 10;
    }
}

