/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.TokenIF;
import com.sap.sdt.util.parse.TokenMatcherIF;
import com.sap.sdt.util.parse.TokenReaderIF;
import java.util.Stack;

class PatternTokenReader
implements TokenReaderIF,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/PatternTokenReader.java#2 $";
    private TokenReaderIF source;
    private TokenMatcherIF pattMatch;
    private Stack tokStack = new Stack();
    private TokenIF[] tokens = new TokenIF[100];
    private TokenIF ungettok = null;

    public PatternTokenReader(TokenReaderIF source, TokenMatcherIF pattMatch) {
        this.source = source;
        this.pattMatch = pattMatch;
    }

    public void close() throws DiagException {
        this.source.close();
        this.source = null;
        this.pattMatch = null;
        this.tokStack = null;
        this.tokens = null;
    }

    public void setIgnoreWhiteSpace(boolean ignwhitespace) {
        this.source.setIgnoreWhiteSpace(ignwhitespace);
    }

    public void setRecognizeComments(boolean recognizecomments) {
        this.source.setRecognizeComments(recognizecomments);
    }

    public void setReadBooleanToken(boolean booleantoken) {
        this.source.setReadBooleanToken(booleantoken);
    }

    public TokenIF getToken() throws DiagException {
        try {
            return this.doGetToken1();
        }
        catch (DiagException e) {
            throw new ParserException(e);
        }
    }

    TokenIF doGetToken1() throws DiagException {
        TokenIF token = this.ungettok;
        if (token != null) {
            this.ungettok = null;
            return token;
        }
        this.pattMatch.reset();
        int match = -1;
        int n = 0;
        while (match == -1) {
            token = this.doGetToken2();
            if (token == null) {
                match = 0;
                break;
            }
            if (n >= this.tokens.length) {
                this.resizeTokenArray();
            }
            this.tokens[n++] = token;
            match = this.pattMatch.matches(this.tokens, n);
        }
        if (match == 0 && n <= 1) {
            return token;
        }
        if (match < n) {
            int start = match == 0 ? 1 : match;
            TokenIF[] remTokens = new TokenIF[n - start];
            System.arraycopy(this.tokens, start, remTokens, 0, n - start);
            this.tokStack.push(new ArrayTokenReader(remTokens));
            if (match == 0) {
                return this.tokens[0];
            }
        }
        TokenIF[] substTokens = this.pattMatch.getSubstitute(this.tokens, match);
        this.tokStack.push(new ArrayTokenReader(substTokens, 1));
        return substTokens[0];
    }

    public void unGetToken(TokenIF token) throws DiagException {
        if (this.ungettok != null) {
            throw new ParserException("msg.parse.0020");
        }
        this.ungettok = token;
    }

    private TokenIF doGetToken2() throws DiagException {
        while (!this.tokStack.empty()) {
            ArrayTokenReader curr = (ArrayTokenReader)this.tokStack.peek();
            TokenIF token = curr.getToken();
            if (token != null) {
                return token;
            }
            curr.close();
            this.tokStack.pop();
        }
        return this.source.getToken();
    }

    private void resizeTokenArray() {
        int n = this.tokens.length;
        TokenIF[] newtokens = new TokenIF[n + 100];
        while (--n >= 0) {
            newtokens[n] = this.tokens[n];
        }
        this.tokens = newtokens;
    }

    private static class ArrayTokenReader
    implements TokenReaderIF {
        private TokenIF[] tokens;
        private int start;
        private TokenIF ungettok = null;

        public ArrayTokenReader(TokenIF[] tokens) {
            this(tokens, 0);
        }

        public ArrayTokenReader(TokenIF[] tokens, int start) {
            this.tokens = tokens;
            this.start = start;
        }

        public void setIgnoreWhiteSpace(boolean ignwhitespace) {
        }

        public void setRecognizeComments(boolean recognizecomments) {
        }

        public void setReadBooleanToken(boolean booleantoken) {
        }

        public TokenIF getToken() throws DiagException {
            if (this.ungettok != null) {
                TokenIF token = this.ungettok;
                this.ungettok = null;
                return token;
            }
            if (this.start == this.tokens.length) {
                return null;
            }
            return this.tokens[this.start++];
        }

        public void unGetToken(TokenIF token) throws DiagException {
            if (this.ungettok != null) {
                throw new ParserException("msg.parse.0020");
            }
            this.ungettok = token;
        }

        public void close() throws DiagException {
            this.tokens = null;
        }
    }
}

