/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.FileException;
import com.sap.sdt.util.diag.WrapperIOException;
import com.sap.sdt.util.parse.CharMatcherIF;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;

public class PatternCharReader
extends Reader
implements MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/PatternCharReader.java#2 $";
    private Reader source;
    private CharMatcherIF pattMatch;
    private Stack inputStack = new Stack();

    public static void convert(String input, String output, CharMatcherIF pattMatch) throws ParserException {
        PatternCharReader.convert(new File(input), new File(output), pattMatch);
    }

    public static void convert(File infile, File outfile, CharMatcherIF pattMatch) throws ParserException {
        try {
            String line;
            PatternCharReader preader = new PatternCharReader(new FileReader(infile), pattMatch);
            BufferedReader in = new BufferedReader(preader);
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            while ((line = in.readLine()) != null) {
                out.write(line + "\n");
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            if (e instanceof WrapperIOException) {
                throw new ParserException(((WrapperIOException)e).getDiagException());
            }
            throw new ParserException("msg.parse.0007", new FileException(e));
        }
    }

    public static String convert(String input, CharMatcherIF pattMatch) throws ParserException {
        PatternCharReader pReader = new PatternCharReader(new StringReader(input), pattMatch);
        try {
            int c;
            StringBuffer str = new StringBuffer();
            while ((c = pReader.read()) != -1) {
                str.append((char)c);
            }
            return str.toString();
        }
        catch (IOException e) {
            if (e instanceof WrapperIOException) {
                throw new ParserException(((WrapperIOException)e).getDiagException());
            }
            throw new ParserException("msg.parse.0007", new FileException(e));
        }
    }

    public PatternCharReader(Reader source, CharMatcherIF pattMatch) {
        this.source = source;
        this.pattMatch = pattMatch;
    }

    public void close() throws IOException {
        this.source.close();
        this.source = null;
        this.pattMatch = null;
        this.inputStack = null;
    }

    public int read() throws IOException {
        try {
            return this.doRead();
        }
        catch (DiagException mex) {
            throw new WrapperIOException(mex);
        }
    }

    private int doRead() throws IOException, DiagException {
        this.pattMatch.reset();
        String pattern = "";
        int c = -1;
        int match = -1;
        while (match == -1) {
            c = this.doReadStack();
            if (c == -1) {
                match = 0;
                break;
            }
            if (!this.shallExpand()) {
                match = 0;
                break;
            }
            pattern = pattern + (char)c;
            match = this.pattMatch.matches(pattern);
        }
        int n = pattern.length();
        if (match == 0 && n <= 1) {
            return c;
        }
        if (match < n) {
            int start = match == 0 ? 1 : match;
            String remainder = pattern.substring(start, n);
            this.inputStack.push(new MyStringReader(remainder, true));
            if (match == 0) {
                return pattern.charAt(0);
            }
        }
        pattern = pattern.substring(0, match);
        String substitute = this.pattMatch.getSubstitute(pattern);
        boolean recursive = this.pattMatch.expandRecursive(pattern);
        this.inputStack.push(new MyStringReader(substitute.substring(1), recursive));
        return substitute.charAt(0);
    }

    private int doReadStack() throws IOException {
        while (!this.inputStack.empty()) {
            Reader curr = (Reader)this.inputStack.peek();
            int c = curr.read();
            if (c != -1) {
                return c;
            }
            curr.close();
            this.inputStack.pop();
        }
        return this.source.read();
    }

    private boolean shallExpand() {
        if (this.inputStack.empty()) {
            return true;
        }
        return ((MyStringReader)this.inputStack.peek()).getRecursive();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int i;
        for (i = 0; i < len && (c = this.read()) != -1; ++i) {
            cbuf[off + i] = (char)c;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public boolean markSupported() {
        return false;
    }

    private static class MyStringReader
    extends StringReader {
        private boolean recursive;

        public MyStringReader(String string, boolean recursive) {
            super(string);
            this.recursive = recursive;
        }

        public boolean getRecursive() {
            return this.recursive;
        }
    }
}

