/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.parse.BooleanToken;
import com.sap.sdt.util.parse.ExpressionValueIF;
import com.sap.sdt.util.parse.IntNumberToken;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.NumberToken;
import com.sap.sdt.util.parse.OperatorIF;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.StringToken;
import com.sap.sdt.util.parse.TokenVector;

class OperatorFactory
implements MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/OperatorFactory.java#2 $";
    public static final String UNARY_OPERATORS = "-!~";
    public static final String TWOCHAR_OPERATOR_START = "<>&|=!";

    OperatorFactory() {
    }

    public static OperatorIF getOperator(String string, boolean isbinary) {
        AbstractOperator op = null;
        if (!isbinary) {
            if (string.equals("-")) {
                op = new UnaryMinus(1);
            } else if (string.equals("!")) {
                op = new LogicalNot(1);
            } else if (string.equals("~")) {
                op = new ArithNot(1);
            }
        } else if (string.equals("*")) {
            op = new Times(2);
        } else if (string.equals("/")) {
            op = new Divide(2);
        } else if (string.equals("%")) {
            op = new Modulo(2);
        } else if (string.equals("+")) {
            op = new Plus(3);
        } else if (string.equals("-")) {
            op = new Minus(3);
        } else if (string.equals("<<")) {
            op = new LShift(4);
        } else if (string.equals(">>")) {
            op = new RShift(4);
        } else if (string.equals("<") || string.equalsIgnoreCase("lt")) {
            op = new Lower(5);
        } else if (string.equals("<=") || string.equalsIgnoreCase("le")) {
            op = new LowerEqual(5);
        } else if (string.equals(">") || string.equalsIgnoreCase("gt")) {
            op = new Greater(5);
        } else if (string.equals(">=") || string.equalsIgnoreCase("ge")) {
            op = new GreaterEqual(5);
        } else if (string.equals("==") || string.equalsIgnoreCase("eq")) {
            op = new Equal(6);
        } else if (string.equals("!=") || string.equalsIgnoreCase("ne")) {
            op = new NotEqual(6);
        } else if (string.equals("&")) {
            op = new ArithAnd(7);
        } else if (string.equals("^")) {
            op = new ArithExOr(8);
        } else if (string.equals("|")) {
            op = new ArithOr(9);
        } else if (string.equals("&&") || string.equalsIgnoreCase("and")) {
            op = new LogicalAnd(10);
        } else if (string.equals("||") || string.equalsIgnoreCase("or")) {
            op = new LogicalOr(11);
        } else if (string.equals(",")) {
            op = new Comma(12);
        }
        return op;
    }

    public static OperatorIF getFunction(String name) {
        AbstractFunction op = null;
        if (name.equals("min")) {
            op = new MinMaxFunction(name, false);
        } else if (name.equals("max")) {
            op = new MinMaxFunction(name, true);
        } else if (name.equals("substring")) {
            op = new SubStringFunction(name);
        }
        return op;
    }

    private static class SubStringFunction
    extends AbstractFunction {
        public SubStringFunction(String name) {
            super(name);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            String result;
            if (!(args[0] instanceof TokenVector)) {
                return args[0];
            }
            ExpressionValueIF[] values = ((TokenVector)args[0]).getVector();
            int n = values.length;
            if (n != 2 && n != 3) {
                throw new BadOperationException(this, args[0]);
            }
            if (!(values[1] instanceof IntNumberToken)) {
                throw new ParserException("msg.parse.0031", ((Object)values[1]).toString());
            }
            int start = (int)((IntNumberToken)values[1]).getLong();
            if (n == 3) {
                if (!(values[2] instanceof IntNumberToken)) {
                    throw new ParserException("msg.parse.0031", ((Object)values[2]).toString());
                }
                int end = (int)((IntNumberToken)values[1]).getLong();
                result = ((Object)values[0]).toString().substring(start, end);
            } else {
                result = ((Object)values[0]).toString().substring(start);
            }
            return new StringToken(result, true);
        }
    }

    private static class MinMaxFunction
    extends AbstractFunction {
        private boolean isMaxFunction;

        public MinMaxFunction(String name, boolean isMaxFunction) {
            super(name);
            this.isMaxFunction = isMaxFunction;
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            NumberToken result;
            if (!(args[0] instanceof TokenVector)) {
                return args[0];
            }
            ExpressionValueIF[] values = ((TokenVector)args[0]).getVector();
            int n = values.length;
            int type = 1;
            long longresult = 0L;
            double doubleresult = 0.0;
            block8: for (int i = 0; i < n; ++i) {
                switch (type) {
                    case 1: {
                        if (values[i] instanceof IntNumberToken) {
                            long lval = ((IntNumberToken)values[i]).getLong();
                            if (i != 0 && !(this.isMaxFunction ? lval > longresult : lval < longresult)) continue block8;
                            longresult = lval;
                            continue block8;
                        }
                        type = 2;
                        doubleresult = longresult;
                    }
                    case 2: {
                        if (values[i] instanceof NumberToken) {
                            double dval = ((NumberToken)values[i]).getDouble();
                            if (i != 0 && !(this.isMaxFunction ? dval > doubleresult : dval < doubleresult)) continue block8;
                            doubleresult = dval;
                            continue block8;
                        }
                        type = 3;
                    }
                    case 3: {
                        throw new BadOperationException(this, values[i]);
                    }
                }
            }
            switch (type) {
                case 1: {
                    result = new IntNumberToken(longresult);
                    break;
                }
                default: {
                    result = new NumberToken(doubleresult);
                }
            }
            return result;
        }
    }

    private static abstract class AbstractFunction
    implements OperatorIF {
        String name;

        public AbstractFunction(String name) {
            this.name = name;
        }

        public int getPriority() {
            return 1;
        }

        public int getNrArgs() {
            return 1;
        }

        public abstract ExpressionValueIF operate(ExpressionValueIF[] var1) throws ParserException;

        public String toString() {
            return this.name;
        }
    }

    private static class Comma
    extends AbstractOperator {
        public Comma(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            TokenVector vector;
            if (!(args[0] instanceof TokenVector)) {
                vector = new TokenVector();
                vector.add(args[0]);
            } else {
                vector = (TokenVector)args[0];
            }
            vector.add(args[1]);
            return vector;
        }

        public String toString() {
            return ",";
        }
    }

    private static class LogicalOr
    extends AbstractOperator {
        public LogicalOr(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof BooleanToken && args[1] instanceof BooleanToken) {
                BooleanToken boto1 = (BooleanToken)args[0];
                BooleanToken boto2 = (BooleanToken)args[1];
                boolean r = boto1.getBoolean() || boto2.getBoolean();
                return new BooleanToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "||";
        }
    }

    private static class LogicalAnd
    extends AbstractOperator {
        public LogicalAnd(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof BooleanToken && args[1] instanceof BooleanToken) {
                BooleanToken boto1 = (BooleanToken)args[0];
                BooleanToken boto2 = (BooleanToken)args[1];
                boolean r = boto1.getBoolean() && boto2.getBoolean();
                return new BooleanToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "&&";
        }
    }

    private static class ArithOr
    extends AbstractOperator {
        public ArithOr(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() | inum2.getLong();
                return new IntNumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "|";
        }
    }

    private static class ArithExOr
    extends AbstractOperator {
        public ArithExOr(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() ^ inum2.getLong();
                return new IntNumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "^";
        }
    }

    private static class ArithAnd
    extends AbstractOperator {
        public ArithAnd(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() & inum2.getLong();
                return new IntNumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "&";
        }
    }

    private static class NotEqual
    extends AbstractOperator {
        public NotEqual(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                boolean r = inum1.getLong() != inum2.getLong();
                return new BooleanToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                boolean r = num1.getDouble() != num2.getDouble();
                return new BooleanToken(r);
            }
            return new BooleanToken(((Object)args[0]).toString().compareTo(((Object)args[1]).toString()) != 0);
        }

        public String toString() {
            return "!=";
        }
    }

    private static class Equal
    extends AbstractOperator {
        public Equal(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                boolean r = inum1.getLong() == inum2.getLong();
                return new BooleanToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                boolean r = num1.getDouble() == num2.getDouble();
                return new BooleanToken(r);
            }
            return new BooleanToken(((Object)args[0]).toString().compareTo(((Object)args[1]).toString()) == 0);
        }

        public String toString() {
            return "==";
        }
    }

    private static class GreaterEqual
    extends AbstractOperator {
        public GreaterEqual(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                boolean r = inum1.getLong() >= inum2.getLong();
                return new BooleanToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                boolean r = num1.getDouble() >= num2.getDouble();
                return new BooleanToken(r);
            }
            return new BooleanToken(((Object)args[0]).toString().compareTo(((Object)args[1]).toString()) >= 0);
        }

        public String toString() {
            return ">=";
        }
    }

    private static class Greater
    extends AbstractOperator {
        public Greater(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                boolean r = inum1.getLong() > inum2.getLong();
                return new BooleanToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                boolean r = num1.getDouble() > num2.getDouble();
                return new BooleanToken(r);
            }
            return new BooleanToken(((Object)args[0]).toString().compareTo(((Object)args[1]).toString()) > 0);
        }

        public String toString() {
            return ">";
        }
    }

    private static class LowerEqual
    extends AbstractOperator {
        public LowerEqual(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                boolean r = inum1.getLong() <= inum2.getLong();
                return new BooleanToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                boolean r = num1.getDouble() <= num2.getDouble();
                return new BooleanToken(r);
            }
            return new BooleanToken(((Object)args[0]).toString().compareTo(((Object)args[1]).toString()) <= 0);
        }

        public String toString() {
            return "<=";
        }
    }

    private static class Lower
    extends AbstractOperator {
        public Lower(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                boolean r = inum1.getLong() < inum2.getLong();
                return new BooleanToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                boolean r = num1.getDouble() < num2.getDouble();
                return new BooleanToken(r);
            }
            return new BooleanToken(((Object)args[0]).toString().compareTo(((Object)args[1]).toString()) < 0);
        }

        public String toString() {
            return "<";
        }
    }

    private static class RShift
    extends AbstractOperator {
        public RShift(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() >> (int)inum2.getLong();
                return new IntNumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return ">>";
        }
    }

    private static class LShift
    extends AbstractOperator {
        public LShift(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() << (int)inum2.getLong();
                return new IntNumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "<<";
        }
    }

    private static class Minus
    extends AbstractOperator {
        public Minus(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() - inum2.getLong();
                return new IntNumberToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                double r = num1.getDouble() - num2.getDouble();
                return new NumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "-";
        }
    }

    private static class Plus
    extends AbstractOperator {
        public Plus(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() + inum2.getLong();
                return new IntNumberToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                double r = num1.getDouble() + num2.getDouble();
                return new NumberToken(r);
            }
            return new StringToken(((Object)args[0]).toString() + ((Object)args[1]).toString(), true);
        }

        public String toString() {
            return "+";
        }
    }

    private static class Modulo
    extends AbstractOperator {
        public Modulo(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() % inum2.getLong();
                return new IntNumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "%";
        }
    }

    private static class Divide
    extends AbstractOperator {
        public Divide(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() / inum2.getLong();
                return new IntNumberToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                double r = num1.getDouble() / num2.getDouble();
                return new NumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "/";
        }
    }

    private static class Times
    extends AbstractOperator {
        public Times(int priority) {
            super(priority, 2);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken && args[1] instanceof IntNumberToken) {
                IntNumberToken inum1 = (IntNumberToken)args[0];
                IntNumberToken inum2 = (IntNumberToken)args[1];
                long r = inum1.getLong() * inum2.getLong();
                return new IntNumberToken(r);
            }
            if (args[0] instanceof NumberToken && args[1] instanceof NumberToken) {
                NumberToken num1 = (NumberToken)args[0];
                NumberToken num2 = (NumberToken)args[1];
                double r = num1.getDouble() * num2.getDouble();
                return new NumberToken(r);
            }
            throw new BadOperationException(this, args[0], args[1]);
        }

        public String toString() {
            return "*";
        }
    }

    private static class ArithNot
    extends AbstractOperator {
        public ArithNot(int priority) {
            super(priority, 1);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken) {
                IntNumberToken inum = (IntNumberToken)args[0];
                long r = inum.getLong() ^ 0xFFFFFFFFFFFFFFFFL;
                return new IntNumberToken(r);
            }
            throw new BadOperationException(this, args[0]);
        }

        public String toString() {
            return "~";
        }
    }

    private static class LogicalNot
    extends AbstractOperator {
        public LogicalNot(int priority) {
            super(priority, 1);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof BooleanToken) {
                BooleanToken boto = (BooleanToken)args[0];
                boolean r = !boto.getBoolean();
                return new BooleanToken(r);
            }
            throw new BadOperationException(this, args[0]);
        }

        public String toString() {
            return "!";
        }
    }

    private static class UnaryMinus
    extends AbstractOperator {
        public UnaryMinus(int priority) {
            super(priority, 1);
        }

        public ExpressionValueIF operate(ExpressionValueIF[] args) throws ParserException {
            if (args[0] instanceof IntNumberToken) {
                IntNumberToken inum = (IntNumberToken)args[0];
                long r = -inum.getLong();
                return new IntNumberToken(r);
            }
            if (args[0] instanceof NumberToken) {
                NumberToken num = (NumberToken)args[0];
                double r = -num.getDouble();
                return new NumberToken(r);
            }
            throw new BadOperationException(this, args[0]);
        }

        public String toString() {
            return "-";
        }
    }

    private static class BadOperationException
    extends ParserException {
        public BadOperationException(OperatorIF op) {
            super("msg.parse.0029");
        }

        public BadOperationException(OperatorIF op, ExpressionValueIF a) {
            super("msg.parse.0029", new String[]{((Object)op).toString(), ((Object)a).toString()});
        }

        public BadOperationException(OperatorIF op, ExpressionValueIF a, ExpressionValueIF b) {
            super("msg.parse.0029", new String[]{((Object)op).toString(), ((Object)a).toString(), ((Object)b).toString()});
        }
    }

    private static abstract class AbstractOperator
    implements OperatorIF {
        private int priority;
        private int nrargs;

        public AbstractOperator(int priority, int nrargs) {
            this.priority = priority;
            this.nrargs = nrargs;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getNrArgs() {
            return this.nrargs;
        }

        public abstract ExpressionValueIF operate(ExpressionValueIF[] var1) throws ParserException;

        public abstract String toString();
    }
}

