/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.FileException;
import com.sap.sdt.util.diag.WrapperIOException;
import com.sap.sdt.util.parse.Calculator;
import com.sap.sdt.util.parse.DefaultMacro;
import com.sap.sdt.util.parse.IllegalMacroValueException;
import com.sap.sdt.util.parse.MacroException;
import com.sap.sdt.util.parse.MacroInputStack;
import com.sap.sdt.util.parse.MacroProviderIF;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParseTraceIF;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.UnknownMacroException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class MacroReader
extends Reader
implements MsgIdConstants,
ParseTraceIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/MacroReader.java#2 $";
    private static final char MACRO_START = '$';
    private static final char MACRO_BRA = '(';
    private static final char MACRO_KET = ')';
    private static final char MACRO_ARGBRA = '(';
    private static final char MACRO_ARGKET = ')';
    private static final char MACRO_EXPRBRA = '[';
    private static final char MACRO_EXPRKET = ']';
    private MacroProviderIF macHandler = null;
    private MacroInputStack inputStack = new MacroInputStack();
    private boolean checksyntax = true;
    private boolean needbrackets = false;
    private StringBuffer strBuffer = new StringBuffer(256);

    public MacroReader(MacroProviderIF macHandler) {
        this.macHandler = macHandler;
    }

    public MacroReader(Reader reader, MacroProviderIF macHandler) {
        this(macHandler);
        this.open(reader);
    }

    public MacroReader(String string, MacroProviderIF macHandler) {
        this(macHandler);
        this.open(string);
    }

    public void open(Reader reader) {
        this.inputStack.init(reader);
    }

    public void open(String string) {
        this.inputStack.init(new StringReader(string));
    }

    public void close() throws IOException {
        this.inputStack.close();
    }

    public void setCheckSyntax(boolean checksyntax) {
        this.checksyntax = checksyntax;
    }

    public boolean getCheckSyntax() {
        return this.checksyntax;
    }

    public void setNeedBrackets(boolean needbrackets) {
        this.needbrackets = needbrackets;
    }

    public boolean getNeedBrackets() {
        return this.needbrackets;
    }

    public static String substitute(String string, MacroProviderIF macHandler) throws ParserException {
        return MacroReader.substitute(string, macHandler, true);
    }

    public static String substitute(String string, MacroProviderIF macHandler, boolean checksyntax) throws ParserException {
        MacroReader mreader = new MacroReader(macHandler);
        mreader.setCheckSyntax(checksyntax);
        return mreader.substitute(string);
    }

    public String substitute(String string) throws ParserException {
        this.open(string);
        try {
            int c;
            StringBuffer str = new StringBuffer();
            while ((c = this.doRead()) != -1) {
                str.append((char)c);
            }
            return str.toString();
        }
        catch (IOException e) {
            throw new ParserException("msg.parse.0007", new FileException(e));
        }
    }

    public int read() throws IOException {
        try {
            return this.doRead();
        }
        catch (DiagException mex) {
            throw new WrapperIOException(mex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int doRead() throws ParserException, IOException {
        int bracnt = 0;
        String macname = null;
        Vector<String> argvec = new Vector<String>();
        int index = 0;
        String argControl = null;
        int state = 0;
        while (true) {
            int c = this.inputStack.getChar();
            if (!this.inputStack.expandMacros()) {
                return c;
            }
            switch (state) {
                case 0: {
                    if (c != 36) return c;
                    bracnt = 0;
                    macname = null;
                    argvec.clear();
                    index = 0;
                    argControl = null;
                    this.strBuffer.delete(0, this.strBuffer.length());
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 40) {
                        bracnt = 1;
                        state = 20;
                    } else if (c == 91) {
                        bracnt = 1;
                        state = 30;
                    } else if (c != -1 && Character.isDigit((char)c)) {
                        state = 15;
                    } else {
                        if (c == 36) {
                            return 36;
                        }
                        if (c != -1 && this.isIdentifierStart((char)c)) {
                            state = 10;
                        } else {
                            if (this.checksyntax) {
                                throw new MacroException("msg.parse.0001", "" + c);
                            }
                            this.unGetChar(c);
                            return 36;
                        }
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 10: {
                    if (c == 40 && (argControl = this.wrapHasArguments(macname = this.strBuffer.toString())) != null) {
                        bracnt = 1;
                        state = 11;
                        index = this.strBuffer.length() + 1;
                    } else if (c == -1 || !this.isIdentifierPart((char)c)) {
                        this.unGetChar(c);
                        if (macname == null) {
                            macname = this.strBuffer.toString();
                        }
                        if (!this.needbrackets && this.expandMacro(macname, null)) {
                            state = 0;
                            break;
                        }
                        this.pushString(macname);
                        return 36;
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 11: {
                    if (c == 40) {
                        ++bracnt;
                    } else if (c == 44 && bracnt == 1) {
                        argvec.add(this.strBuffer.substring(index));
                        index = this.strBuffer.length() + 1;
                    } else if (c == 41) {
                        if (--bracnt == 0) {
                            argvec.add(this.strBuffer.substring(index));
                            String[] args = argvec.toArray(new String[argvec.size()]);
                            if (!this.expandMacro(macname, null, args, argControl)) {
                                this.strBuffer.append((char)c);
                                this.inputStack.pushString(this.strBuffer.toString(), true);
                                return 36;
                            }
                            state = 0;
                            break;
                        }
                    } else if (c == -1) {
                        String remainder = this.strBuffer.toString();
                        if (this.checksyntax) {
                            throw new MacroException("msg.parse.0002", remainder);
                        }
                        this.pushString(remainder);
                        return 36;
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 15: {
                    if (c == -1 || !Character.isDigit((char)c)) {
                        this.unGetChar(c);
                        macname = this.strBuffer.toString();
                        if (!this.expandMacroArg(macname)) {
                            this.pushString(macname);
                            return 36;
                        }
                        state = 0;
                        break;
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 20: {
                    if (c != -1 && Character.isDigit((char)c)) {
                        state = 25;
                    } else {
                        if (c == -1 || !this.isIdentifierStartInBrackets((char)c)) {
                            String string;
                            if (!this.checksyntax) {
                                this.unGetChar(c);
                                this.unGetChar(40);
                                return 36;
                            }
                            if (c == -1) {
                                string = "msg.parse.0003";
                                throw new MacroException(string, "$(" + c);
                            }
                            string = "msg.parse.0004";
                            throw new MacroException(string, "$(" + c);
                        }
                        state = 21;
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 21: 
                case 22: {
                    if (c == 58 && state != 22) {
                        index = this.strBuffer.length();
                        state = 22;
                    } else if (c == 40) {
                        ++bracnt;
                    } else if (c == 41) {
                        if (--bracnt == 0) {
                            state += 2;
                        }
                    } else if (c == -1 || state == 21 && !this.isIdentifierPartInBrackets((char)c)) {
                        String string;
                        if (!this.checksyntax) {
                            this.unGetChar(c);
                            this.pushString(this.strBuffer.toString());
                            return 36;
                        }
                        if (c == -1) {
                            string = "msg.parse.0003";
                            throw new MacroException(string, "$" + c);
                        }
                        string = "msg.parse.0004";
                        throw new MacroException(string, "$" + c);
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 23: 
                case 24: {
                    String defvalue;
                    if (state == 23) {
                        macname = this.strBuffer.substring(1, this.strBuffer.length() - 1);
                        defvalue = null;
                    } else {
                        macname = this.strBuffer.substring(1, index);
                        defvalue = this.strBuffer.substring(index + 1, this.strBuffer.length() - 1);
                    }
                    if (c == 40 && (argControl = this.wrapHasArguments(macname)) != null) {
                        bracnt = 1;
                        state = 11;
                        index = this.strBuffer.length();
                        break;
                    }
                    this.unGetChar(c);
                    if (!this.expandMacro(macname, defvalue)) {
                        this.pushString(this.strBuffer.toString());
                        return 36;
                    }
                    state = 0;
                    break;
                }
                case 25: {
                    if (c == 41) {
                        if (!this.expandMacroArg(this.strBuffer.substring(1))) {
                            this.strBuffer.append((char)c);
                            this.pushString(this.strBuffer.toString());
                            return 36;
                        }
                        state = 0;
                        break;
                    }
                    if (c == -1 || !Character.isDigit((char)c)) {
                        String string;
                        if (c != -1) {
                            this.strBuffer.append((char)c);
                        }
                        String remainder = this.strBuffer.toString();
                        if (!this.checksyntax) {
                            this.pushString(remainder);
                            return 36;
                        }
                        if (c == -1) {
                            string = "msg.parse.0005";
                            throw new MacroException(string, '$' + remainder);
                        }
                        string = "msg.parse.0006";
                        throw new MacroException(string, '$' + remainder);
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 30: {
                    if (c == 93) {
                        if (!this.expandArithExpression(this.strBuffer.substring(1))) {
                            this.strBuffer.append((char)c);
                            this.pushString(this.strBuffer.toString());
                            return 36;
                        }
                        state = 0;
                        break;
                    }
                    if (c == -1) {
                        String string;
                        String remainder = this.strBuffer.toString();
                        if (!this.checksyntax) {
                            this.pushString(remainder);
                            return 36;
                        }
                        if (c == -1) {
                            string = "msg.parse.0005";
                            throw new MacroException(string, 127 + remainder);
                        }
                        string = "msg.parse.0006";
                        throw new MacroException(string, 127 + remainder);
                    }
                    this.strBuffer.append((char)c);
                }
            }
        }
    }

    private boolean isIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    private boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    private boolean isIdentifierStartInBrackets(char c) {
        return c != ')';
    }

    private boolean isIdentifierPartInBrackets(char c) {
        return c != ')';
    }

    protected void unGetChar(int c) {
        if (c != -1) {
            this.inputStack.unGetChar(c);
        }
    }

    protected void pushString(String string) {
        this.inputStack.pushString(string);
    }

    private boolean expandMacro(String name, String defval) throws ParserException {
        return this.expandMacro(name, defval, null, null);
    }

    private boolean expandMacro(String name, String defval, String[] args, String argControl) throws ParserException {
        String macdef;
        boolean recursive;
        if (this.inputStack.isExpanded(name)) {
            trc.debug(this.getClass(), "Inhibit recursive expansion of '" + name + "'");
            return false;
        }
        try {
            recursive = this.macHandler.expandRecursively(name);
        }
        catch (DiagException e2) {
            if (e2 instanceof UnknownMacroException) {
                throw (UnknownMacroException)e2;
            }
            throw new ParserException("msg.parse.0008", e2);
        }
        trc.debug(this.getClass(), "Expand macro '" + name + "' " + (recursive ? "" : "non-") + "recursively");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (i < argControl.length() && argControl.charAt(i) == 'p') continue;
                String arg = args[i];
                args[i] = MacroReader.substitute(arg, this.macHandler, this.checksyntax);
                trc.debug(this.getClass(), "Expanded macro argument " + i + " '" + arg + "' to '" + args[i] + "'");
            }
        }
        try {
            macdef = this.getValue(name, args);
        }
        catch (UnknownMacroException e) {
            if (defval == null) {
                if (!this.checksyntax) {
                    return false;
                }
                throw e;
            }
            macdef = defval;
        }
        this.inputStack.pushExpansion(name, macdef, recursive, args);
        return true;
    }

    private boolean expandMacroArg(String string) throws ParserException {
        if (this.inputStack.getArgs() == null) {
            return this.expandMacro(string, null, null, null);
        }
        int nr = Integer.parseInt(string);
        try {
            String argdef = this.inputStack.getArg(nr);
            this.inputStack.pushArgExpansion(argdef);
        }
        catch (MacroException e) {
            if (!this.checksyntax) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private boolean expandArithExpression(String expression) throws ParserException {
        try {
            String result = Calculator.getCalculator().evaluateString(new MacroReader(expression, this.macHandler));
            trc.debug(this.getClass(), "Evaluate '" + expression + "' to '" + result + "'");
            this.inputStack.pushString(result);
        }
        catch (ParserException e) {
            if (!this.checksyntax) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private String getValue(String name, String[] args) throws ParserException {
        String result;
        try {
            result = DefaultMacro.getValue(name, args);
        }
        catch (UnknownMacroException e) {
            if (this.macHandler == null) {
                throw e;
            }
            try {
                result = this.macHandler.getValue(name, args);
            }
            catch (DiagException e2) {
                if (e2 instanceof UnknownMacroException) {
                    throw (UnknownMacroException)e2;
                }
                throw new ParserException("msg.parse.0008", e2);
            }
        }
        if (result == null) {
            throw new IllegalMacroValueException(name);
        }
        return result;
    }

    private String wrapHasArguments(String name) throws ParserException {
        try {
            return this.hasArguments(name);
        }
        catch (UnknownMacroException e) {
            return null;
        }
    }

    private String hasArguments(String name) throws ParserException {
        try {
            try {
                return DefaultMacro.hasArguments(name);
            }
            catch (UnknownMacroException e) {
                if (this.macHandler == null) {
                    throw e;
                }
                return this.macHandler.hasArguments(name);
            }
        }
        catch (DiagException e2) {
            throw new ParserException("msg.parse.0008", e2);
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int i;
        for (i = 0; i < len && (c = this.read()) != -1; ++i) {
            cbuf[off + i] = (char)c;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public boolean markSupported() {
        return false;
    }
}

