/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.parse.MacroException;
import com.sap.sdt.util.parse.MsgIdConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;

class MacroInputStack
extends Stack
implements MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/MacroInputStack.java#2 $";
    private final int MAXUNGETS = 2;

    public void init(Reader reader) {
        this.clear();
        this.pushReader(reader);
    }

    public void close() throws IOException {
        while (!this.empty()) {
            MyReader reader = (MyReader)this.peek();
            reader.close();
            this.pop();
        }
    }

    public int getChar() throws IOException {
        while (!this.empty()) {
            MyReader reader = (MyReader)this.peek();
            int c = reader.getChar();
            if (c != -1) {
                return c;
            }
            this.pop();
        }
        return -1;
    }

    public void unGetChar(int c) {
        if (c == -1) {
            return;
        }
        if (this.empty()) {
            this.pushString("");
        }
        MyReader myreader = (MyReader)this.peek();
        myreader.unGetChar(c);
    }

    public void pushExpansion(String macName, String content, boolean expandMacros, String[] args) {
        this.pushExpansion(macName, new StringReader(content), expandMacros, args);
    }

    private void pushExpansion(String macName, Reader reader, boolean expandMacros, String[] args) {
        MyReader myreader = new MyReader(macName, reader, expandMacros, args);
        this.push(myreader);
    }

    public void pushReader(Reader reader) {
        this.pushExpansion("", reader, true, null);
    }

    public void pushString(String string, boolean useoldargs) {
        String[] args = null;
        if (useoldargs) {
            MyReader myreader = (MyReader)this.peek();
            args = myreader.getArgs();
        }
        this.pushExpansion("", string, true, args);
    }

    public void pushString(String string) {
        this.pushString(string, false);
    }

    public void pushArgExpansion(String content) {
        this.pushExpansion(null, new StringReader(content), true, null);
    }

    public boolean isExpanded(String macName) {
        MyReader myreader;
        String name;
        for (int i = this.size() - 1; i >= 0 && (name = (myreader = (MyReader)this.get(i)).getMacName()) != null; --i) {
            if (!macName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean expandMacros() {
        if (this.empty()) {
            return true;
        }
        MyReader myreader = (MyReader)this.peek();
        return myreader.getExpandMacros();
    }

    public String getArg(int nr) throws MacroException {
        MyReader myreader = (MyReader)this.peek();
        return myreader.getArg(nr);
    }

    public String[] getArgs() throws MacroException {
        MyReader myreader = (MyReader)this.peek();
        return myreader.getArgs();
    }

    private class MyReader {
        private String macName;
        private Reader reader;
        private boolean expandMacros;
        private String[] args;
        private String fileName = null;
        private int lineNumber = 0;
        private char[] ungets = new char[2];
        private int ungeti = 0;

        public MyReader(String macName, Reader reader, boolean expandMacros, String[] args) {
            this.macName = macName;
            this.reader = reader;
            this.expandMacros = expandMacros;
            this.args = args;
        }

        public String getMacName() {
            return this.macName;
        }

        public String[] getArgs() {
            return this.args;
        }

        public boolean getExpandMacros() {
            return this.expandMacros;
        }

        public void close() throws IOException {
            this.macName = null;
            this.reader.close();
            this.reader = null;
            this.args = null;
            this.ungets = null;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getChar() throws IOException {
            if (this.ungeti > 0) {
                return this.ungets[--this.ungeti];
            }
            int c = this.reader.read();
            if (c == 10) {
                ++this.lineNumber;
            }
            return c;
        }

        public void unGetChar(int c) {
            this.ungets[this.ungeti++] = (char)c;
        }

        public String getArg(int nr) throws MacroException {
            if (this.args == null) {
                throw new MacroException("msg.parse.0010");
            }
            if (nr < 0 || nr >= this.args.length) {
                throw new MacroException("msg.parse.0011");
            }
            return this.args[nr];
        }
    }
}

