/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.parse.InvalidArgTypeException;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.UnknownMacroException;
import com.sap.sdt.util.parse.WrongNumberArgsException;
import com.sap.sdt.util.vers.SAPVersion;
import java.io.File;

class DefaultMacro
implements MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/DefaultMacro.java#2 $";

    DefaultMacro() {
    }

    public static String getValue(String name, String[] args) throws ParserException {
        if (name.equals("MAX")) {
            return DefaultMacro.doMaximum(args);
        }
        if (name.equals("MIN")) {
            return DefaultMacro.doMinimum(args);
        }
        if (name.equals("SUBSTR")) {
            return DefaultMacro.doSubStr(args);
        }
        if (name.equals("FILE")) {
            return DefaultMacro.doFile(args);
        }
        if (name.equals("SAPRELCMP")) {
            return DefaultMacro.doSAPRelCmp(args);
        }
        throw new UnknownMacroException(name);
    }

    public static String hasArguments(String name) throws ParserException {
        if (name.equals("MAX") || name.equals("MIN") || name.equals("SUBSTR") || name.equals("FILE") || name.equals("SAPRELCMP")) {
            return "";
        }
        throw new UnknownMacroException(name);
    }

    private static String doMaximum(String[] args) throws ParserException {
        int i = 0;
        try {
            double current = Double.parseDouble(args[0]);
            for (i = 1; i < args.length; ++i) {
                double next = Double.parseDouble(args[i]);
                if (!(next > current)) continue;
                current = next;
            }
            return Double.toString(current);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgTypeException("MAX", args[i]);
        }
    }

    private static String doMinimum(String[] args) throws ParserException {
        int i = 0;
        try {
            double current = Double.parseDouble(args[0]);
            for (i = 1; i < args.length; ++i) {
                double next = Double.parseDouble(args[i]);
                if (!(next < current)) continue;
                current = next;
            }
            return Double.toString(current);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgTypeException("MIN", args[i]);
        }
    }

    private static String doSubStr(String[] args) throws ParserException {
        int arg2;
        int arg1;
        int nargs = args.length;
        if (nargs != 2 && nargs != 3) {
            throw new WrongNumberArgsException("SUBSTR", args.length, "2 or 3");
        }
        try {
            arg1 = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgTypeException("SUBSTR", args[1]);
        }
        if (nargs == 2) {
            try {
                return args[0].substring(arg1);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ParserException("msg.parse.0050", new JavaException(e), new String[]{args[0], "" + arg1});
            }
        }
        try {
            arg2 = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgTypeException("SUBSTR", args[2]);
        }
        try {
            return args[0].substring(arg1, arg2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParserException("msg.parse.0050", new JavaException(e), new String[]{args[0], "" + arg1, "" + arg2});
        }
    }

    private static String doFile(String[] args) throws ParserException {
        if (args.length != 2) {
            throw new ParserException("msg.parse.0051");
        }
        return args[0] + File.separatorChar + args[1];
    }

    private static String doSAPRelCmp(String[] args) throws ParserException {
        if (args.length != 2) {
            throw new WrongNumberArgsException("SAPRELCMP", args.length, 2);
        }
        try {
            SAPVersion vers1 = new SAPVersion(args[0]);
            return Integer.toString(vers1.compare(new SAPVersion(args[1])));
        }
        catch (DiagException e) {
            throw new ParserException("msg.parse.0050", new JavaException(e));
        }
    }
}

