/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.BooleanToken;
import com.sap.sdt.util.parse.CharToken;
import com.sap.sdt.util.parse.ExpressionValueIF;
import com.sap.sdt.util.parse.IdentToken;
import com.sap.sdt.util.parse.IntNumberToken;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.NumberToken;
import com.sap.sdt.util.parse.OperatorFactory;
import com.sap.sdt.util.parse.OperatorIF;
import com.sap.sdt.util.parse.ParseTraceIF;
import com.sap.sdt.util.parse.ParserException;
import com.sap.sdt.util.parse.SpaceToken;
import com.sap.sdt.util.parse.StringToken;
import com.sap.sdt.util.parse.TokenIF;
import com.sap.sdt.util.parse.TokenReaderFactory;
import com.sap.sdt.util.parse.TokenReaderIF;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Stack;

public class Calculator
implements MsgIdConstants,
ParseTraceIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/Calculator.java#2 $";
    private static Calculator defaultCalculator = new Calculator();
    public static final boolean DOTRACE = false;
    private Stack varstack = new Stack();
    private Stack opstack = new Stack();

    public static Calculator getCalculator() {
        return defaultCalculator;
    }

    public boolean evaluateBoolean(String string) throws ParserException {
        return this.evaluateBoolean(new StringReader(string), false);
    }

    public long evaluateLong(String string) throws ParserException {
        return this.evaluateLong(new StringReader(string), false);
    }

    public double evaluateDouble(String string) throws ParserException {
        return this.evaluateDouble(new StringReader(string), false);
    }

    public String evaluateString(String string) throws ParserException {
        return this.evaluateString(new StringReader(string), false);
    }

    public boolean evaluateBoolean(Reader reader) throws ParserException {
        return this.evaluateBoolean(reader, true);
    }

    public boolean evaluateBoolean(Reader reader, boolean ignoreRemainder) throws ParserException {
        TokenIF token = this.evaluate(reader, ignoreRemainder);
        if (!(token instanceof BooleanToken)) {
            throw new ParserException("msg.parse.0030", ((Object)token).toString());
        }
        return ((BooleanToken)token).getBoolean();
    }

    public long evaluateLong(Reader reader) throws ParserException {
        return this.evaluateLong(reader, true);
    }

    public long evaluateLong(Reader reader, boolean ignoreRemainder) throws ParserException {
        TokenIF token = this.evaluate(reader, ignoreRemainder);
        if (!(token instanceof IntNumberToken)) {
            throw new ParserException("msg.parse.0031", ((Object)token).toString());
        }
        return ((IntNumberToken)token).getLong();
    }

    public double evaluateDouble(Reader reader) throws ParserException {
        return this.evaluateDouble(reader, true);
    }

    public double evaluateDouble(Reader reader, boolean ignoreRemainder) throws ParserException {
        TokenIF token = this.evaluate(reader, ignoreRemainder);
        if (!(token instanceof NumberToken)) {
            throw new ParserException("msg.parse.0032", ((Object)token).toString());
        }
        return ((NumberToken)token).getDouble();
    }

    public String evaluateString(Reader reader) throws ParserException {
        return this.evaluateString(reader, true);
    }

    public String evaluateString(Reader reader, boolean ignoreRemainder) throws ParserException {
        TokenIF token = this.evaluate(reader, ignoreRemainder);
        return ((Object)token).toString();
    }

    public TokenIF evaluate(Reader reader) throws ParserException {
        return this.evaluate(reader, true);
    }

    public TokenIF evaluate(String string) throws ParserException {
        return this.evaluate(new StringReader(string), true);
    }

    public TokenIF evaluate(Reader reader, boolean ignoreRemainder) throws ParserException {
        TokenReaderIF tokreader = TokenReaderFactory.getTokenReader(reader);
        tokreader.setReadBooleanToken(true);
        return this.evaluate(tokreader, ignoreRemainder);
    }

    public TokenIF evaluate(TokenReaderIF tokreader) throws ParserException {
        return this.evaluate(tokreader, true);
    }

    public TokenIF evaluate(TokenReaderIF tokreader, boolean ignoreRemainder) throws ParserException {
        try {
            return this.doEvaluate(tokreader, ignoreRemainder);
        }
        catch (DiagException e) {
            throw new ParserException(e);
        }
    }

    private TokenIF doEvaluate(TokenReaderIF tokreader, boolean ignoreRemainder) throws DiagException {
        TokenIF token;
        this.varstack.clear();
        this.opstack.clear();
        boolean expectvariable = true;
        int bracketcount = 0;
        while ((token = tokreader.getToken()) != null) {
            OperatorIF optok;
            char c;
            char c2 = c = token instanceof CharToken ? ((CharToken)token).getCharacter() : (char)'\u0000';
            if (token instanceof SpaceToken) continue;
            if (expectvariable) {
                if (c == '(') {
                    this.doPushOperator(token);
                    ++bracketcount;
                    continue;
                }
                if ("-!~".indexOf(c) >= 0) {
                    optok = this.getOperator(tokreader, token, false);
                    this.pushOperator(optok);
                    continue;
                }
                if (!(token instanceof NumberToken) && !(token instanceof StringToken) && !(token instanceof IdentToken) && !(token instanceof BooleanToken)) break;
                this.doPushVariable((ExpressionValueIF)((Object)token));
                expectvariable = false;
                continue;
            }
            if (c == '(') {
                TokenIF last = (TokenIF)this.varstack.pop();
                if (!(last instanceof IdentToken)) {
                    throw new ParserException("msg.parse.0033");
                }
                OperatorIF optok2 = OperatorFactory.getFunction(((Object)last).toString());
                this.pushOperator(optok2);
                this.doPushOperator(token);
                ++bracketcount;
                expectvariable = true;
                continue;
            }
            if (c == ')') {
                if (bracketcount == 0) {
                    tokreader.unGetToken(token);
                    break;
                }
                this.popOperators(true);
                --bracketcount;
                continue;
            }
            optok = this.getOperator(tokreader, token, true);
            if (optok == null) {
                tokreader.unGetToken(token);
                break;
            }
            this.pushOperator(optok);
            expectvariable = true;
        }
        if (expectvariable) {
            throw new ParserException("msg.parse.0033");
        }
        if (token != null && !ignoreRemainder) {
            throw new ParserException("msg.parse.0035", ((Object)token).toString());
        }
        this.popOperators(false);
        if (!this.opstack.isEmpty()) {
            throw new ParserException("msg.parse.0034");
        }
        if (this.varstack.size() != 1) {
            throw new ParserException("msg.parse.0035");
        }
        return (TokenIF)this.varstack.pop();
    }

    private void pushOperator(OperatorIF op) throws ParserException {
        this.doOperatorStack(op, false);
    }

    private void popOperators(boolean removebracket) throws ParserException {
        this.doOperatorStack(null, removebracket);
    }

    private void doOperatorStack(OperatorIF op, boolean removebracket) throws ParserException {
        Object top;
        int nrArgs;
        if (op != null && (nrArgs = op.getNrArgs()) == 1) {
            this.doPushOperator(op);
            return;
        }
        while (!this.opstack.isEmpty() && (top = this.opstack.peek()) instanceof OperatorIF) {
            int prio;
            OperatorIF topop = (OperatorIF)top;
            int topprio = topop.getPriority();
            if (op != null && (prio = op.getPriority()) < topprio) break;
            this.evalOperator(topop);
            this.opstack.pop();
        }
        if (op != null) {
            this.doPushOperator(op);
        } else if (removebracket) {
            if (this.opstack.isEmpty()) {
                throw new ParserException("msg.parse.0036");
            }
            this.opstack.pop();
        }
    }

    private void evalOperator(OperatorIF op) throws ParserException {
        if (this.varstack.size() < op.getNrArgs()) {
            throw new ParserException("msg.parse.0037");
        }
        int n = op.getNrArgs();
        ExpressionValueIF[] vals = new ExpressionValueIF[n];
        for (int i = n - 1; i >= 0; --i) {
            vals[i] = (ExpressionValueIF)this.varstack.pop();
        }
        this.doPushVariable(op.operate(vals));
    }

    private void doPushOperator(Object op) {
        this.opstack.push(op);
    }

    private void doPushVariable(ExpressionValueIF value) {
        this.varstack.push(value);
    }

    private OperatorIF getOperator(TokenReaderIF tokreader, TokenIF token, boolean isbinary) throws DiagException {
        if (token instanceof CharToken) {
            char c = ((CharToken)token).getCharacter();
            String opstr = "" + c;
            if ("<>&|=!".indexOf(c) >= 0) {
                token = tokreader.getToken();
                if (token instanceof CharToken) {
                    c = ((CharToken)token).getCharacter();
                    OperatorIF op = OperatorFactory.getOperator(opstr + c, isbinary);
                    if (op != null) {
                        return op;
                    }
                }
                tokreader.unGetToken(token);
            }
            return OperatorFactory.getOperator(opstr, isbinary);
        }
        if (token instanceof IdentToken) {
            String opname = ((Object)token).toString();
            return OperatorFactory.getOperator(opname, isbinary);
        }
        return null;
    }

    public void TRACE(TokenIF token) {
        if (token != null) {
            trc.debug(this.getClass(), "TOKEN '" + ((Object)token).toString() + "'");
        } else {
            trc.debug(this.getClass(), "FINISHED");
        }
        String result = "  VARSTACK";
        Iterator it = this.varstack.iterator();
        while (it.hasNext()) {
            result = result + " '" + it.next().toString() + "'";
        }
        trc.debug(this.getClass(), result);
        result = "  OPSTACK";
        it = this.opstack.iterator();
        while (it.hasNext()) {
            result = result + " '" + it.next().toString() + "'";
        }
        trc.debug(this.getClass(), result);
    }
}

