/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.parse;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.MacroProviderIF;
import com.sap.sdt.util.parse.MsgIdConstants;
import com.sap.sdt.util.parse.ParserException;

public abstract class AbstractMacroProvider
implements MacroProviderIF,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/parse/AbstractMacroProvider.java#2 $";

    public boolean expandRecursively(String name) {
        return true;
    }

    public MacroProviderIF.MacroIteratorIF getValues(String name) throws DiagException {
        String value = this.getValue(name, null);
        return new SingleIterator(value, this.expandRecursively(name));
    }

    private static class SingleIterator
    implements MacroProviderIF.MacroIteratorIF {
        private MacroProviderIF macprovider;

        public SingleIterator(String value, boolean expandRecursively) {
            this.macprovider = new SingleIteratorMacroProvider(value, expandRecursively);
        }

        public boolean hasNext() {
            return this.macprovider != null;
        }

        public MacroProviderIF next() {
            MacroProviderIF ret = this.macprovider;
            this.macprovider = null;
            return ret;
        }

        private class SingleIteratorMacroProvider
        implements MacroProviderIF {
            private String value;
            private boolean expandRecursively;

            public SingleIteratorMacroProvider(String value, boolean expandRecursively) {
                this.value = value;
                this.expandRecursively = expandRecursively;
            }

            public String getValue(String name, String[] args) throws DiagException {
                if (name != null) {
                    throw new ParserException("msg.parse.0009");
                }
                return this.value;
            }

            public boolean expandRecursively(String name) {
                return this.expandRecursively;
            }

            public String hasArguments(String name) throws DiagException {
                return null;
            }

            public MacroProviderIF.MacroIteratorIF getValues(String name) throws DiagException {
                if (name != null) {
                    throw new ParserException("msg.parse.0009");
                }
                return new SingleIterator(this.value, this.expandRecursively);
            }
        }
    }
}

