/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.net;

import com.sap.sdt.util.net.BindFailedException;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.DefaultCommLink;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.net.NetworkIOException;
import java.io.IOException;
import java.net.ServerSocket;

public class ServerCommLink {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/net/ServerCommLink.java#2 $";
    private ServerSocket serverSocket = null;
    private boolean isClosed = true;

    public ServerCommLink(int port) throws NetworkException {
        try {
            this.serverSocket = new ServerSocket(port);
        }
        catch (IOException ioE) {
            throw new BindFailedException(port, ioE);
        }
        this.isClosed = false;
    }

    public CommLinkIF accept() throws NetworkException {
        CommLinkIF commLink = this.createCommLink();
        try {
            commLink.connect(this.serverSocket.accept());
        }
        catch (IOException ioE) {
            throw new NetworkIOException(ioE);
        }
        return commLink;
    }

    public void close() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected CommLinkIF createCommLink() {
        return new DefaultCommLink();
    }
}

