/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.net;

import com.sap.sdt.util.net.CommLinkClosedException;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.CommLinkObserverIF;
import com.sap.sdt.util.net.ConnectFailedException;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.net.NetworkIOException;
import com.sap.sdt.util.net.USEException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractCommLink
implements CommLinkIF,
Runnable {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/net/AbstractCommLink.java#2 $";
    protected Thread engine = null;
    protected boolean isConnected = false;
    protected Vector observers = new Vector();
    protected Socket socket = null;
    protected InputStream in = null;
    protected OutputStream out = null;

    public AbstractCommLink() {
        this.engine = new Thread(this);
        this.engine.setName("CommLink(" + this.getClass().getName() + ")");
    }

    public void addObserver(CommLinkObserverIF observer) {
        this.observers.add(observer);
    }

    public void connect(String host, int port) throws NetworkException {
        try {
            this.socket = this.createSocket(host, port);
        }
        catch (IOException ioE) {
            throw new ConnectFailedException(host, port);
        }
        this.init();
        this.isConnected = true;
    }

    public void connect(Socket socket) throws NetworkException {
        this.socket = socket;
        this.init();
        this.isConnected = true;
    }

    public void start() {
        this.engine.start();
    }

    public void stop() {
        this.isConnected = false;
        this.close();
    }

    public void send(String msg) throws NetworkException {
        if (!this.isConnected) {
            throw new CommLinkClosedException();
        }
        try {
            byte[] hdrBuf = new byte[this.getHdrLength()];
            byte[] msgBuf = msg.getBytes(this.getMsgEnc());
            this.setMsgLength(hdrBuf, msgBuf.length);
            this.out.write(hdrBuf);
            this.out.write(msgBuf);
            this.out.flush();
        }
        catch (UnsupportedEncodingException useE) {
            throw new USEException(this.getMsgEnc());
        }
        catch (IOException ioE) {
            throw new NetworkIOException(ioE);
        }
    }

    public String receive() throws NetworkException {
        byte[] hdrBuf = new byte[this.getHdrLength()];
        if (this.read(hdrBuf) < 0) {
            this.isConnected = false;
            throw new NetworkIOException();
        }
        byte[] msgBuf = new byte[this.getMsgLength(hdrBuf)];
        if (this.read(msgBuf) < 0) {
            throw new NetworkIOException();
        }
        String msg = null;
        try {
            msg = new String(msgBuf, this.getMsgEnc());
        }
        catch (UnsupportedEncodingException useE) {
            throw new USEException(this.getMsgEnc());
        }
        return msg;
    }

    public void run() {
        String msg = null;
        while (this.isConnected) {
            try {
                msg = this.receive();
                this.fireMsgReceived(msg);
                Thread.yield();
            }
            catch (NetworkException nwE) {
                if (this.isConnected) {
                    this.fireNetworkError(nwE);
                }
                this.isConnected = false;
            }
        }
        this.close();
        this.fireCommLinkClosed();
    }

    protected abstract int getHdrLength();

    protected abstract int getMsgLength(byte[] var1);

    protected abstract void setMsgLength(byte[] var1, int var2);

    protected abstract String getMsgEnc();

    protected void fireMsgReceived(String msg) {
        CommLinkObserverIF observer = null;
        Iterator it = this.observers.iterator();
        while (it.hasNext()) {
            observer = (CommLinkObserverIF)it.next();
            observer.msgReceived(msg);
        }
    }

    protected void fireNetworkError(NetworkException nwE) {
        CommLinkObserverIF observer = null;
        Iterator it = this.observers.iterator();
        while (it.hasNext()) {
            observer = (CommLinkObserverIF)it.next();
            observer.networkError(nwE);
        }
    }

    protected void fireCommLinkClosed() {
        CommLinkObserverIF observer = null;
        Iterator it = this.observers.iterator();
        while (it.hasNext()) {
            observer = (CommLinkObserverIF)it.next();
            observer.commLinkClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        try {
            block6: {
                try {
                    if (this.out != null) {
                        this.out.close();
                        this.out = null;
                    }
                    if (this.in != null) {
                        this.in.close();
                        this.in = null;
                    }
                    if (this.socket == null) break block6;
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.socket = null;
                    this.out = null;
                    this.in = null;
                }
            }
            Object var3_1 = null;
            this.socket = null;
            this.out = null;
            this.in = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.socket = null;
            this.out = null;
            this.in = null;
            throw throwable;
        }
    }

    protected Socket createSocket(String host, int port) throws IOException {
        InetAddress inetAddr = host != null && !host.equals("localhost") ? InetAddress.getByName(host) : InetAddress.getLocalHost();
        Socket socket = new Socket(inetAddr, port);
        socket.setTcpNoDelay(true);
        return socket;
    }

    protected void init() throws NetworkIOException {
        try {
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (IOException ioE) {
            throw new NetworkIOException(ioE);
        }
    }

    protected int read(byte[] msg) throws NetworkException {
        int remaining;
        int offset = 0;
        try {
            int read;
            for (remaining = msg.length; remaining > 0; remaining -= read) {
                read = this.in.read(msg, offset, remaining);
                if (read < 0) {
                    return -1;
                }
                offset += read;
            }
        }
        catch (IOException ioE) {
            throw new NetworkIOException(ioE);
        }
        return msg.length - remaining;
    }
}

