/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeStamp {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/TimeStamp.java#2 $";
    private long milliSecs = 0L;
    private static char[] seps = new char[]{'/', ' ', ':', '.'};

    public TimeStamp() {
        this.milliSecs = new Date().getTime();
    }

    public TimeStamp(Date _date) {
        this.milliSecs = _date.getTime();
    }

    public TimeStamp(long _milliSecs) {
        this.milliSecs = _milliSecs;
    }

    public void set(long _milliSecs) {
        this.milliSecs = _milliSecs;
    }

    public void set(Date _date) {
        this.milliSecs = _date.getTime();
    }

    public long getTime() {
        return this.milliSecs;
    }

    public Date getDate() {
        return new Date(this.milliSecs);
    }

    public String toString() {
        return TimeStamp.toString(new Date(this.milliSecs));
    }

    public String toStringFormat() {
        return TimeStamp.toStringFormat(new Date(this.milliSecs));
    }

    public static String toString(long milliSecs) {
        return TimeStamp.toStringFormat(new Date(milliSecs));
    }

    public static String toString(Date date) {
        return TimeStamp.toFormatString(date, false, false, ' ', ' ', ' ', ' ');
    }

    public static String toStringFormat(long milliSecs) {
        return TimeStamp.toStringFormat(new Date(milliSecs));
    }

    public static String toStringFormat(Date date) {
        return TimeStamp.toFormatString(date, true, false, seps[0], seps[1], seps[2], seps[3]);
    }

    private static String toFormatString(Date date, boolean withSeps, boolean withMS, char sepJMD, char sepDH, char sepHMS, char sepMS) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        StringBuffer time = new StringBuffer();
        int val = 0;
        time.append(c.get(1));
        if (withSeps) {
            time.append(sepJMD);
        }
        if ((val = c.get(2) + 1) < 10) {
            time.append(0);
        }
        time.append(val);
        if (withSeps) {
            time.append(sepJMD);
        }
        if ((val = c.get(5)) < 10) {
            time.append(0);
        }
        time.append(val);
        if (withSeps) {
            time.append(sepDH);
        }
        if ((val = c.get(11)) < 10) {
            time.append(0);
        }
        time.append(val);
        if (withSeps) {
            time.append(sepHMS);
        }
        if ((val = c.get(12)) < 10) {
            time.append(0);
        }
        time.append(val);
        if (withSeps) {
            time.append(sepHMS);
        }
        if ((val = c.get(13)) < 10) {
            time.append(0);
        }
        time.append(val);
        if (withMS) {
            val = c.get(14);
            if (withSeps) {
                time.append(sepMS);
            }
            if (val < 1000) {
                time.append(0);
            }
            if (val < 100) {
                time.append(0);
            }
            if (val < 10) {
                time.append(0);
            }
            time.append(val);
        }
        return time.toString();
    }

    public static Date parseString(String in) {
        int inx;
        int len = in.length();
        if (in == null || len <= 0) {
            return null;
        }
        String digits = "0123456789";
        for (inx = 0; digits.indexOf(in.charAt(inx)) < 0 && inx < len; ++inx) {
        }
        if (inx >= len) {
            return null;
        }
        int sepp = 0;
        if (in.indexOf(seps[0]) >= 0) {
            sepp = 1;
        }
        if (in.length() - inx < 14 + 5 * sepp) {
            return null;
        }
        try {
            int year = Integer.parseInt(in.substring(inx, inx + 4));
            int month = Integer.parseInt(in.substring(inx += 4 + sepp, inx + 2)) - 1;
            int day = Integer.parseInt(in.substring(inx += 2 + sepp, inx + 2));
            int hour = Integer.parseInt(in.substring(inx += 2 + sepp, inx + 2));
            int min = Integer.parseInt(in.substring(inx += 2 + sepp, inx + 2));
            int sec = Integer.parseInt(in.substring(inx += 2 + sepp, inx + 2));
            int ms = 0;
            if (in.length() - (inx += 2 + sepp) >= 4) {
                try {
                    ms = Integer.parseInt(in.substring(inx, inx + 4));
                }
                catch (NumberFormatException ex) {
                    ms = 0;
                }
            }
            GregorianCalendar c = new GregorianCalendar();
            c.set(year, month, day, hour, min, sec);
            ((Calendar)c).roll(14, ms);
            return c.getTime();
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Date parseString(String pattern, String in) {
        Date date = null;
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            date = format.parse(in);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return date;
    }
}

