/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import java.util.Date;

public class TimeDiff {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/TimeDiff.java#2 $";
    private long stopMilli = 0L;
    private long startMilli = 0L;
    private long timeDiff = 0L;
    private boolean positive = true;
    private static final int UNKNOWN = -1;
    public static final int MILLI = 0;
    public static final int SEC = 1;
    public static final int MIN = 2;
    public static final int HOUR = 3;
    public static final int DAY = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    private static final int LAST = 7;
    private static String[] sepsDots = new String[]{".", ":", ":", ","};
    private static String[] sepsDHMS = new String[]{"s ", "m ", "h ", "d "};

    public TimeDiff(Date stop, Date start) {
        this(stop.getTime(), start.getTime());
    }

    public TimeDiff(long stop, long start) {
        this.stopMilli = stop;
        this.startMilli = start;
        if (this.stopMilli >= this.startMilli) {
            this.timeDiff = this.stopMilli - this.startMilli;
            this.positive = true;
        } else {
            this.timeDiff = this.startMilli - this.stopMilli;
            this.positive = false;
        }
    }

    public long getTime() {
        return this.positive ? this.timeDiff : -1L * this.timeDiff;
    }

    public String toString(boolean withMilli) {
        return TimeDiff.toStringFormatDots(this.positive ? this.timeDiff : -1L * this.timeDiff, 4, withMilli);
    }

    public static String toStringFormatDots(long diff, int max, boolean withMilli) {
        return TimeDiff.toFormatString(diff, max, withMilli, sepsDots);
    }

    public static String toStringFormatDHMS(long diff, int max, boolean withMilli) {
        return TimeDiff.toFormatString(diff, max, withMilli, sepsDHMS);
    }

    private static String toFormatString(long diff, int max, boolean withMilli, String[] seps) {
        if (max < 0) {
            max = 0;
        }
        if (max > 4) {
            max = 4;
        }
        long[] val = TimeDiff.splitter(diff, max);
        StringBuffer time = new StringBuffer();
        if (diff < 0L) {
            time.append('-');
        }
        if (max >= 4 && val[4] > 0L) {
            if (max > 4 && val[4] < 10L) {
                time.append(0);
            }
            time.append(val[4]);
            time.append(seps[3]);
        }
        if (max >= 3) {
            if (max > 3 && val[4] > 0L && val[3] < 10L) {
                time.append(0);
            }
            time.append(val[3]);
            time.append(seps[2]);
        }
        if (max >= 2) {
            if (max > 2 && val[2] < 10L) {
                time.append(0);
            }
            time.append(val[2]);
            time.append(seps[1]);
        }
        if (max >= 1) {
            if (max > 1 && val[1] < 10L) {
                time.append(0);
            }
            time.append(val[1]);
        }
        if (withMilli) {
            time.append(seps[0]);
            if (val[0] < 100L) {
                time.append(0);
            }
            if (val[0] < 10L) {
                time.append(0);
            }
            time.append("" + val[0]);
        }
        return time.toString();
    }

    private static long[] splitter(long diff, int max) {
        if (max < 0) {
            max = 0;
        }
        if (max > 4) {
            max = 4;
        }
        if (diff < 0L) {
            diff = -diff;
        }
        long[] parts = new long[max + 1 - 0];
        long sec = diff / 1000L;
        long min = sec / 60L;
        long hour = min / 60L;
        long day = hour / 24L;
        if (max == 0) {
            parts[0] = diff;
            return parts;
        }
        parts[0] = diff % 1000L;
        if (max == 1) {
            parts[1] = sec;
            return parts;
        }
        parts[1] = sec % 60L;
        if (max == 2) {
            parts[2] = min;
            return parts;
        }
        parts[2] = min % 60L;
        if (max == 3) {
            parts[3] = hour;
            return parts;
        }
        parts[3] = hour % 24L;
        parts[4] = day;
        return parts;
    }
}

