/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.misc.Semaphore;

public class SyncBuffer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/SyncBuffer.java#2 $";
    public static int DEFAULT_SIZE = 16;
    private int size;
    private int elements;
    private int readPos;
    private int writePos;
    private Object[] buffer;
    private Semaphore mutex;
    private Semaphore empty;
    private Semaphore full;

    public SyncBuffer() {
        this(DEFAULT_SIZE);
    }

    public SyncBuffer(int bufSize) {
        this.size = bufSize;
        this.mutex = new Semaphore(1);
        this.empty = new Semaphore(this.size);
        this.full = new Semaphore(0);
        this.elements = 0;
        this.readPos = 0;
        this.writePos = 0;
        this.buffer = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = null;
        }
    }

    public Object get() {
        this.full.down();
        this.mutex.down();
        Object obj = this.buffer[this.readPos];
        this.buffer[this.readPos] = null;
        this.readPos = (this.readPos + 1) % this.size;
        --this.elements;
        this.mutex.up();
        this.empty.up();
        return obj;
    }

    public void put(Object obj) {
        this.empty.down();
        this.mutex.down();
        this.buffer[this.writePos] = obj;
        this.writePos = (this.writePos + 1) % this.size;
        ++this.elements;
        this.mutex.up();
        this.full.up();
    }

    public synchronized boolean hasMoreElements() {
        this.mutex.down();
        boolean result = this.elements > 0;
        this.mutex.up();
        return result;
    }
}

