/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StringHelper {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/StringHelper.java#2 $";

    public static StringBuffer replace(String text, char oldChar, String newString) {
        return StringHelper.replace(new StringBuffer(text), oldChar, newString);
    }

    public static StringBuffer replace(StringBuffer text, char oldChar, String newString) {
        if (newString.length() == 1 && newString.charAt(0) == oldChar) {
            return text;
        }
        try {
            int i = 0;
            int offset = newString.length();
            while (true) {
                if (text.charAt(i) == oldChar) {
                    text.deleteCharAt(i);
                    text.insert(i, newString);
                    i += offset;
                    continue;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return text;
        }
    }

    public static StringBuffer fill(StringBuffer toFill, char fillWith) {
        return StringHelper.fill(toFill, fillWith, toFill.capacity());
    }

    public static StringBuffer fill(StringBuffer toFill, char fillWith, int len) {
        for (int i = 0; i < len; ++i) {
            toFill.append(fillWith);
        }
        return toFill;
    }

    public static ArrayList splitString(String sourceString, String delimiter) {
        if (delimiter == null || delimiter.length() == 0) {
            throw new IllegalArgumentException("delimiter must be a valid string");
        }
        ArrayList<String> stringList = new ArrayList<String>();
        if (sourceString == null || sourceString.length() == 0) {
            return stringList;
        }
        StringTokenizer st = new StringTokenizer(sourceString, delimiter);
        while (st.hasMoreTokens()) {
            stringList.add(st.nextToken().trim());
        }
        return stringList;
    }

    public static String getStringWithDelimiter(List stringList, String delimiter) {
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < stringList.size(); ++i) {
            result.append(stringList.get(i));
            if (i >= stringList.size() - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String removeAllSeparators(String string) {
        char[] chars = string.toCharArray();
        StringBuffer cleanString = new StringBuffer(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ' ' || chars[i] == '.') continue;
            cleanString.append(chars[i]);
        }
        return cleanString.toString();
    }

    public static StringBuffer trim(StringBuffer string) {
        int st;
        int count;
        int len = count = string.length();
        for (st = 0; st < len && string.charAt(st) <= ' '; ++st) {
        }
        while (st < len && string.charAt(len - 1) <= ' ') {
            --len;
        }
        if (len < count) {
            string.delete(len, Integer.MAX_VALUE);
        }
        if (st > 0) {
            string.delete(0, st);
        }
        return string;
    }

    public static int indexOfNoneWhitespace(String string) {
        int st;
        int len = string.length();
        for (st = 0; st < len && string.charAt(st) <= ' '; ++st) {
        }
        return st < len ? st : -1;
    }

    public static String replace(String text, String oldStr, String newStr) {
        if (text == null || oldStr == null || newStr == null) {
            return text;
        }
        StringBuffer buff = new StringBuffer();
        int index = 0;
        int lastIndex = 0;
        while ((index = text.indexOf(oldStr, lastIndex)) != -1) {
            buff.append(text.substring(lastIndex, index) + newStr);
            lastIndex = index + oldStr.length();
        }
        buff.append(text.substring(lastIndex, text.length()));
        return buff.toString();
    }
}

