/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class RCSInfo {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/RCSInfo.java#2 $";
    private static final char RCSPATTERN_STARTSTOPCHAR = '$';
    private static final String RCSPATTERN = "Id";
    private JarFile jarfile;
    private Enumeration list;
    private InputStream input = null;

    public RCSInfo(String name) throws IOException {
        this.jarfile = new JarFile(name);
        this.list = this.jarfile.entries();
    }

    public String getID() throws IOException {
        while (true) {
            String result;
            if (this.input != null && (result = this.extractID(this.input)) != null) {
                return result;
            }
            if (!this.list.hasMoreElements()) break;
            JarEntry entry = (JarEntry)this.list.nextElement();
            if (entry.isDirectory()) continue;
            this.input = this.jarfile.getInputStream(entry);
        }
        return null;
    }

    private String extractID(InputStream in) throws IOException {
        int c;
        StringBuffer strbuffer = null;
        int pos = 0;
        while ((c = in.read()) != -1) {
            if (strbuffer != null) {
                strbuffer.append((char)c);
                if (c != 36) continue;
                return strbuffer.toString();
            }
            if ((char)c == (pos == 0 ? (char)'$' : RCSPATTERN.charAt(pos - 1))) {
                if (++pos != RCSPATTERN.length() + 1) continue;
                strbuffer = new StringBuffer();
                strbuffer.append('$');
                strbuffer.append(RCSPATTERN);
                continue;
            }
            pos = (char)c == '$' ? 1 : 0;
        }
        return null;
    }
}

