/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.misc.LoaderException;
import com.sap.sdt.util.misc.LoaderIF;
import com.sap.sdt.util.misc.MiscTraceIF;
import com.sap.sdt.util.string.SString;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class PathClassLoader
implements LoaderIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/PathClassLoader.java#2 $";
    private URLClassLoader urlLoader;

    public PathClassLoader(String path) throws LoaderException {
        this(path, true);
    }

    public PathClassLoader(String path, boolean delegate) throws LoaderException {
        URL[] urls;
        if (path != null) {
            String[] parts = SString.getSubStrings(path, File.pathSeparatorChar);
            int n = parts.length;
            urls = new URL[n];
            try {
                for (int i = 0; i < n; ++i) {
                    String name = parts[i];
                    File f = new File(name);
                    if (f.isDirectory() && !name.endsWith(File.separator)) {
                        name = name + File.separator;
                    }
                    urls[i] = new URL("file:" + name);
                }
            }
            catch (MalformedURLException ex) {
                throw new LoaderException(ex);
            }
        } else {
            urls = new URL[]{};
        }
        ClassLoader cLoader = delegate ? this.getClass().getClassLoader() : new DummyLoader();
        this.urlLoader = new URLClassLoader(urls, cLoader);
    }

    public PathClassLoader() {
        ClassLoader cLoader = this.getClass().getClassLoader();
        this.urlLoader = new URLClassLoader(new URL[0], cLoader);
    }

    public Object newInstance(String name) throws LoaderException {
        try {
            Class cl = this.newClass(name, null);
            return cl.newInstance();
        }
        catch (Exception e) {
            throw new LoaderException(e);
        }
    }

    public Class newClass(String name) throws LoaderException {
        return this.newClass(name, null);
    }

    public Class newClass(String name, Class compatClass) throws LoaderException {
        Class<?> cl;
        MiscTraceIF.trc.debug(this.getClass(), "Load class {0}", name);
        MiscTraceIF.trc.debug(this.getClass(), "{0}", "Compat class has name '" + (compatClass != null ? compatClass.getName() : "null") + "'");
        if (name == null) {
            MiscTraceIF.trc.debug(this.getClass(), "{0}", "Parameter (class) name is 'null'");
            MiscTraceIF.trc.debug(this.getClass(), "Exception {0}.", "LoaderException");
            throw new LoaderException("null", this.urlLoader.getURLs());
        }
        try {
            cl = this.urlLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            MiscTraceIF.trc.debug(this.getClass(), "{0}", "ClassNotFoundException for'" + name + "'");
            MiscTraceIF.trc.debug(this.getClass(), "{0}", e.getMessage());
            MiscTraceIF.trc.debug(this.getClass(), "Exception {0}.", "LoaderException");
            throw new LoaderException(name, this.urlLoader.getURLs());
        }
        if (compatClass != null && !compatClass.isAssignableFrom(cl)) {
            MiscTraceIF.trc.debug(this.getClass(), "{0}", "compatClass != null, but");
            MiscTraceIF.trc.debug(this.getClass(), "Exception {0}.", "compatClass is not assignable from '" + name + "'");
            throw new LoaderException(name, compatClass.getName(), this.urlLoader.getURLs());
        }
        MiscTraceIF.trc.debug(this.getClass(), "Class \"{0}\" loaded", name);
        return cl;
    }

    private static class DummyLoader
    extends ClassLoader {
        private DummyLoader() {
        }

        public Class findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }
    }
}

