/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

public class JavaRuntime {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_compatibility/java/com/sap/sdt/util/misc/JavaRuntime.java#2 $";
    private static final int[] versionParts = new int[16];
    private static int numberVersionParts = 0;

    private JavaRuntime() {
    }

    public static boolean isRequiredVersion(int[] version) {
        int nParts = Math.min(versionParts.length, version.length);
        for (int i = 0; i < nParts; ++i) {
            if (versionParts[i] < version[i]) {
                return false;
            }
            if (versionParts[i] <= version[i]) continue;
            return true;
        }
        return true;
    }

    public static boolean isExactVersion(int[] version) {
        int nParts = Math.min(versionParts.length, version.length);
        for (int i = 0; i < nParts; ++i) {
            if (versionParts[i] == version[i]) continue;
            return false;
        }
        return true;
    }

    public static void list() {
        System.getProperties().list(System.out);
    }

    static {
        char[] version = System.getProperty("java.version").toCharArray();
        int i = 0;
        int begin = 0;
        while (true) {
            if (i < version.length && Character.isDigit(version[i])) {
                ++i;
                continue;
            }
            try {
                JavaRuntime.versionParts[JavaRuntime.numberVersionParts++] = Integer.parseInt(new String(version, begin, i - begin));
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (i < version.length && !Character.isDigit(version[i])) {
                ++i;
            }
            begin = i;
            if (i >= version.length) break;
        }
    }
}

