/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.diag.DirectoryCreateException;
import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFileExtractor {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/JarFileExtractor.java#2 $";
    private JarFile jarFile;

    public JarFileExtractor(File jarFile) throws SDTFileNotFoundException, FileIOException {
        if (!jarFile.exists()) {
            throw new SDTFileNotFoundException(jarFile);
        }
        try {
            this.jarFile = new JarFile(jarFile);
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
    }

    public InputStream getJarEntry(String name) throws SDTFileNotFoundException, IOException {
        Enumeration<JarEntry> en = this.jarFile.entries();
        while (en.hasMoreElements()) {
            JarEntry jarEntry = en.nextElement();
            if (!name.equals(jarEntry.getName())) continue;
            return this.jarFile.getInputStream(jarEntry);
        }
        throw new SDTFileNotFoundException(name);
    }

    public void extract(File toDirectory) throws FileIOException, DirectoryCreateException {
        try {
            JarEntry metaEntry = null;
            Enumeration<JarEntry> en = this.jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry jarEntry = en.nextElement();
                if (jarEntry.isDirectory()) {
                    File dir = new File(toDirectory, jarEntry.getName());
                    dir.mkdir();
                    if (dir.exists()) continue;
                    throw new DirectoryCreateException(dir);
                }
                if ("META-INF/MANIFEST.MF".equals(jarEntry.getName())) {
                    metaEntry = jarEntry;
                    continue;
                }
                this.dump(jarEntry, toDirectory);
            }
            if (metaEntry != null) {
                this.dump(metaEntry, toDirectory);
            }
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
    }

    protected void dump(JarEntry jarEntry, File toDirectory) throws IOException {
        BufferedInputStream in = new BufferedInputStream(this.jarFile.getInputStream(jarEntry));
        File outFile = new File(toDirectory, jarEntry.getName());
        FileOutputStream out = new FileOutputStream(outFile);
        int MAX = 1024;
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        for (long size = jarEntry.getSize(); size > 0L && (bytesRead = in.read(buffer, 0, (int)Math.min(1024L, size))) != -1; size -= (long)bytesRead) {
            out.write(buffer, 0, bytesRead);
        }
        in.close();
        out.flush();
        out.close();
    }
}

