/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class FileClassLoader
extends URLClassLoader {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/FileClassLoader.java#2 $";

    public FileClassLoader(File file) {
        super(FileClassLoader.getURLs(file));
    }

    public FileClassLoader(File file, ClassLoader parent) {
        super(FileClassLoader.getURLs(file), parent);
    }

    public FileClassLoader(File[] files) {
        super(FileClassLoader.getURLs(files));
    }

    public FileClassLoader(File[] files, ClassLoader parent) {
        super(FileClassLoader.getURLs(files), parent);
    }

    public void addFile(File file) {
        super.addURL(FileClassLoader.getURL(file));
    }

    public void addFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addFile(files[i]);
        }
    }

    public File[] getFiles() {
        return FileClassLoader.getFiles(super.getURLs());
    }

    public static FileClassLoader newInstance(File[] files) {
        return new FileClassLoader(files);
    }

    public static FileClassLoader newInstance(File[] files, ClassLoader parent) {
        return new FileClassLoader(files, parent);
    }

    protected static URL[] getURLs(File[] file) {
        URL[] urls = new URL[file.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = FileClassLoader.getURL(file[i]);
        }
        return urls;
    }

    protected static URL[] getURLs(File file) {
        return FileClassLoader.getURLs(new File[]{file});
    }

    protected static File[] getFiles(URL[] urls) {
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = new File(urls[i].getFile());
        }
        return files;
    }

    protected static URL getURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e1) {
                path = file.getAbsolutePath();
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            try {
                return new URL("file", "", path);
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
    }
}

