/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.value.StringArray;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;

public class ClassPathHelper {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/ClassPathHelper.java#2 $";
    private static String sep = System.getProperty("path.separator");

    public static String get(File[] jarFiles) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < jarFiles.length; ++i) {
            if (i > 0) {
                b.append(sep);
            }
            b.append(jarFiles[i].getAbsolutePath());
        }
        return b.toString();
    }

    public static String get(String[] jarFiles) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < jarFiles.length; ++i) {
            if (i > 0) {
                b.append(sep);
            }
            b.append(jarFiles[i]);
        }
        return b.toString();
    }

    public static String get(StringArray jarFiles) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < jarFiles.size(); ++i) {
            if (i > 0) {
                b.append(sep);
            }
            b.append(jarFiles.get(i));
        }
        return b.toString();
    }

    public static File[] toFileArray(String[] jarFiles) {
        File[] array = new File[jarFiles.length];
        for (int i = 0; i < jarFiles.length; ++i) {
            array[i] = new File(jarFiles[i]);
        }
        return array;
    }

    public static File[] toFileArray(StringArray jarFiles) {
        File[] array = new File[jarFiles.size()];
        for (int i = 0; i < jarFiles.size(); ++i) {
            array[i] = new File(jarFiles.get(i));
        }
        return array;
    }

    public static File[] toFileArray(List fileLocations) {
        File[] files = new File[fileLocations.size()];
        for (int i = 0; i < fileLocations.size(); ++i) {
            files[i] = new File((String)fileLocations.get(i));
        }
        return files;
    }

    public static StringArray toStringArray(File[] jarFiles) {
        StringArray array = new StringArray();
        for (int i = 0; i < jarFiles.length; ++i) {
            array.add(jarFiles[i].getAbsolutePath());
        }
        return array;
    }

    public static StringArray toStringArray(String classPath) {
        StringArray array = new StringArray();
        StringTokenizer tokenizer = new StringTokenizer(classPath, sep);
        while (tokenizer.hasMoreTokens()) {
            array.add(tokenizer.nextToken());
        }
        return array;
    }
}

