/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.misc.CRCChecksum;
import com.sap.sdt.util.misc.CheckSummerIF;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.Checksum;

public class CheckSummerFactory {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/CheckSummerFactory.java#2 $";
    private static final String TAG_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final int TAG_CHARACTERS_LENGTH = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".length();
    private static final int TAG_LEN = 6;

    public static CheckSummerIF getValidator(String name) {
        CheckSummerIF vali = name.endsWith(".xml") ? CheckSummerFactory.getXMLValidator() : CheckSummerFactory.getShellValidator();
        return vali;
    }

    public static CheckSummerIF getShellValidator() {
        return CheckSummerFactory.getShellValidator(new CRCChecksum());
    }

    public static CheckSummerIF getShellValidator(Checksum chk) {
        return CheckSummerFactory.getShellValidator(chk, "$VL:%%%%%%$");
    }

    public static CheckSummerIF getShellValidator(Checksum chk, String pattern) {
        return new ShellValidator(chk, pattern);
    }

    public static CheckSummerIF getXMLValidator() {
        return CheckSummerFactory.getXMLValidator(new CRCChecksum());
    }

    public static CheckSummerIF getXMLValidator(Checksum chk) {
        return CheckSummerFactory.getXMLValidator(chk, "$VL:%%%%%%$");
    }

    public static CheckSummerIF getXMLValidator(Checksum chk, String pattern) {
        return new XMLValidator(chk, pattern);
    }

    public static boolean validateFile(String name) throws DiagException {
        return CheckSummerFactory.validateFile(name, CheckSummerFactory.getValidator(name));
    }

    public static boolean validateFile(String name, CheckSummerIF validator) throws DiagException {
        RandomAccessFile rfile;
        File file = new File(name);
        try {
            rfile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new SDTFileNotFoundException(name);
        }
        boolean didValidate = false;
        try {
            int c;
            while ((c = rfile.read()) != -1) {
                validator.update(c);
            }
            if (!validator.checkValidation()) {
                String tag;
                long pos = validator.getTagPosition();
                if (pos == -1L) {
                    pos = rfile.length();
                    tag = validator.generateTag(true);
                } else {
                    tag = validator.generateTag(false);
                }
                rfile.seek(pos);
                rfile.writeBytes(tag);
                didValidate = true;
            }
            rfile.close();
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
        return didValidate;
    }

    public static boolean isCheckSumTagged(String name) throws DiagException {
        return CheckSummerFactory.isCheckSumTagged(name, CheckSummerFactory.getValidator(name));
    }

    public static boolean isCheckSumTagged(String name, CheckSummerIF validator) throws DiagException {
        try {
            int c;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(name));
            while ((c = ((InputStream)in).read()) != -1) {
                validator.update(c);
            }
            return validator.checkValidation();
        }
        catch (FileNotFoundException e) {
            throw new SDTFileNotFoundException(name);
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
    }

    public static String checksum2Tag(long cksum) {
        String result = "";
        for (int i = 0; i < 6; ++i) {
            int k = (int)(cksum % (long)TAG_CHARACTERS_LENGTH);
            cksum /= (long)TAG_CHARACTERS_LENGTH;
            if (k < 0) {
                k += TAG_CHARACTERS_LENGTH;
            }
            result = result + TAG_CHARACTERS.charAt(k);
        }
        if (cksum != 0L) {
            throw new NumberFormatException("checksum too big");
        }
        return result;
    }

    private static class PatternLocator {
        private String pattern;
        private char[] patternBuffer;
        private int current = 0;
        private long position = -1L;
        private String tag = null;

        public PatternLocator(String pattern) {
            this.pattern = pattern;
            this.patternBuffer = new char[pattern.length()];
        }

        public void reset() {
            this.current = 0;
        }

        public String getTag() {
            return this.tag;
        }

        public long getTagPosition() {
            return this.position;
        }

        public String genValidationTag(String newtag) {
            int start = this.pattern.indexOf(37);
            int end = this.pattern.lastIndexOf(37);
            return this.pattern.substring(0, start) + newtag + this.pattern.substring(end + 1);
        }

        public void check(int c, long currpos) {
            char patt = this.pattern.charAt(this.current);
            if (patt != '%' && (char)c != patt) {
                this.current = 0;
                return;
            }
            this.patternBuffer[this.current++] = (char)c;
            if (this.current == this.pattern.length()) {
                int start = this.pattern.indexOf(37);
                int end = this.pattern.lastIndexOf(37);
                this.tag = new String(this.patternBuffer, start, 1 + end - start);
                this.current = 0;
                this.position = currpos - (long)this.pattern.length() + 1L;
            }
        }
    }

    private static class XMLValidator
    extends WhiteSpaceValidator {
        private static final String XMLCOMMENT_START = "<!--";
        private static final String XMLCOMMENT_END = "-->";
        private int state = 0;
        private static final int UPPER_STATE = 1000;

        public XMLValidator(Checksum chk, String pattern) {
            super(chk, pattern);
        }

        public void reset() {
            super.reset();
            this.state = 0;
        }

        public String generateTag(boolean wrapped) {
            String tag = this.patternLocator.genValidationTag(CheckSummerFactory.checksum2Tag(this.getValue()));
            if (wrapped) {
                String prefix = XMLValidator.isNewLine(this.getLastChar()) ? "" : "\n";
                tag = prefix + XMLCOMMENT_START + " " + tag + XMLCOMMENT_END + "\n";
            }
            return tag;
        }

        public void update(int c) {
            block6: {
                ++this.currpos;
                while (true) {
                    if (0 <= this.state && this.state < XMLCOMMENT_START.length()) {
                        if ((char)c == XMLCOMMENT_START.charAt(this.state)) {
                            ++this.state;
                            if (this.state != XMLCOMMENT_START.length()) break;
                            this.state = 1000;
                            this.patternLocator.reset();
                            break;
                        }
                        for (int i = 0; i < this.state; ++i) {
                            super.update(XMLCOMMENT_START.charAt(i));
                        }
                        if (this.state <= 0) break;
                        this.state = 0;
                        continue;
                    }
                    if (1000 > this.state || this.state >= 1000 + XMLCOMMENT_END.length()) break;
                    this.patternLocator.check(c, this.currpos);
                    if ((char)c == XMLCOMMENT_END.charAt(this.state - 1000)) {
                        ++this.state;
                        if (this.state != 1000 + XMLCOMMENT_END.length()) break;
                        this.state = 0;
                        break block6;
                    }
                    if (this.state == 1002 && c == 45) {
                        this.state = 1001;
                        continue;
                    }
                    if (this.state <= 1000) break;
                    this.state = 1000;
                }
                if (this.state != 0) break block6;
                super.update(c);
            }
        }
    }

    private static class ShellValidator
    extends WhiteSpaceValidator {
        private static final char COMMENT_START = '#';
        private static final String VALID_PPSTART = "ie";
        private int inComment = 0;

        public ShellValidator(Checksum chk, String pattern) {
            super(chk, pattern);
        }

        public String generateTag(boolean wrapped) {
            String tag = this.patternLocator.genValidationTag(CheckSummerFactory.checksum2Tag(this.getValue()));
            if (wrapped) {
                String prefix = ShellValidator.isNewLine(this.getLastChar()) ? "" : "\n";
                tag = prefix + '#' + " " + tag + "\n";
            }
            return tag;
        }

        public void reset() {
            super.reset();
            this.inComment = 0;
        }

        public void update(int c) {
            ++this.currpos;
            if (this.inComment == 0) {
                if (ShellValidator.isNewLine(this.getLastChar()) && c == 35) {
                    this.inComment = 1;
                    this.patternLocator.reset();
                } else {
                    super.update(c);
                }
            } else if (this.inComment == 1 && VALID_PPSTART.indexOf(c) != -1) {
                this.inComment = 0;
                super.update(35);
                super.update(c);
            } else {
                this.inComment = 2;
                this.patternLocator.check(c, this.currpos);
                if (ShellValidator.isNewLine(c)) {
                    this.inComment = 0;
                    super.update(c);
                }
            }
        }
    }

    private static abstract class WhiteSpaceValidator
    extends AbstractValidator {
        private Checksum chk;
        private int lastchar = -1;
        protected PatternLocator patternLocator;
        protected long currpos = -1L;

        public WhiteSpaceValidator(Checksum chk, String pattern) {
            this.chk = chk;
            this.patternLocator = new PatternLocator(pattern);
        }

        public long getValue() {
            return this.chk.getValue();
        }

        public String getTag() {
            return this.patternLocator.getTag();
        }

        public long getTagPosition() {
            return this.patternLocator.getTagPosition();
        }

        public void reset() {
            this.currpos = -1L;
            this.lastchar = -1;
            this.chk.reset();
        }

        public void update(int c) {
            if (c == -1) {
                return;
            }
            if (Character.isWhitespace((char)c)) {
                if (this.lastchar != -1) {
                    this.lastchar = WhiteSpaceValidator.isNewLine(c) ? 10 : 32;
                }
                return;
            }
            if (Character.isWhitespace((char)this.lastchar)) {
                this.chk.update(32);
            }
            this.lastchar = c;
            this.chk.update(c);
        }

        protected int getLastChar() {
            return this.lastchar;
        }

        protected static boolean isNewLine(int c) {
            return c == -1 || c == 13 || c == 10;
        }
    }

    private static abstract class AbstractValidator
    implements CheckSummerIF {
        private AbstractValidator() {
        }

        public boolean checkValidation() {
            String tag = this.getTag();
            return tag != null && tag.equals(CheckSummerFactory.checksum2Tag(this.getValue()));
        }
    }
}

