/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import java.util.zip.Checksum;

public class CRCChecksum
implements Checksum {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/CRCChecksum.java#2 $";
    public static final int DEFAULT_POLYNOMIAL = 79764919;
    public static final long DEFAULT_CHKSUM = -1L;
    private long cksum;
    private static final int BITS_PER_CHAR = 8;
    private static final int BITS_PER_CKSUM = 32;
    private static final int BIT_MASK = 255;
    private static final long CKSUM_MASK = 0xFFFFFFFFL;
    private static int[] CRCTable = CRCChecksum.genCRCTable(79764919);

    public CRCChecksum() {
        this(-1L);
    }

    public CRCChecksum(long cksum) {
        this.cksum = cksum;
    }

    public long getValue() {
        return this.cksum;
    }

    public void reset() {
        this.cksum = -1L;
    }

    public void update(byte[] buffer, int off, int len) {
        for (int i = 0; i < len; ++i) {
            byte b = buffer[off + i];
            int index = (int)(this.cksum >>> 24 ^ (long)b) & 0xFF;
            this.cksum = (this.cksum << 8 ^ (long)CRCTable[index]) & 0xFFFFFFFFL;
        }
    }

    public void update(int b) {
        int index = (int)(this.cksum >>> 24 ^ (long)b) & 0xFF;
        this.cksum = (this.cksum << 8 ^ (long)CRCTable[index]) & 0xFFFFFFFFL;
    }

    public static int[] genCRCTable(int polynomial) {
        int i;
        int n = 256;
        int[] table = new int[n];
        int highBit = Integer.MIN_VALUE;
        int[] bitMask = new int[8];
        bitMask[0] = polynomial;
        for (i = 1; i < 8; ++i) {
            bitMask[i] = (bitMask[i - 1] & highBit) != 0 ? (bitMask[i - 1] & ~highBit) << 1 ^ polynomial : bitMask[i - 1] << 1;
        }
        for (i = 0; i < n; ++i) {
            int value = 0;
            int k = 0;
            for (int j = i; j != 0; j >>>= 1) {
                if ((j & 1) != 0) {
                    value ^= bitMask[k];
                }
                ++k;
            }
            table[i] = value;
        }
        return table;
    }
}

