/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.misc.QueueIF;
import com.sap.sdt.util.misc.SemaphoreBuilder;
import com.sap.sdt.util.misc.SemaphoreIF;

class BoundedQueue
implements QueueIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/BoundedQueue.java#3 $";
    public static final int DEFAULT_SIZE = 8;
    private int elements;
    private int readPos;
    private int writePos;
    private Object[] buffer;
    private SemaphoreIF mutex = SemaphoreBuilder.getSemaphore(1);
    private SemaphoreIF empty;
    private SemaphoreIF full;

    public BoundedQueue() {
        this(8);
    }

    public BoundedQueue(int size) {
        this.empty = SemaphoreBuilder.getSemaphore(size);
        this.full = SemaphoreBuilder.getSemaphore(0);
        this.elements = 0;
        this.readPos = 0;
        this.writePos = 0;
        this.buffer = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.buffer[i] = null;
        }
    }

    public Object get() {
        this.full.down();
        this.mutex.down();
        Object obj = this.buffer[this.readPos];
        this.buffer[this.readPos] = null;
        this.readPos = (this.readPos + 1) % this.buffer.length;
        --this.elements;
        this.mutex.up();
        this.empty.up();
        return obj;
    }

    public void put(Object obj) {
        this.empty.down();
        this.mutex.down();
        this.buffer[this.writePos] = obj;
        this.writePos = (this.writePos + 1) % this.buffer.length;
        ++this.elements;
        this.mutex.up();
        this.full.up();
    }

    public synchronized boolean hasMore() {
        this.mutex.down();
        boolean result = this.elements > 0;
        this.mutex.up();
        return result;
    }
}

