/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.misc.JavaRuntime;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class BootStrapper {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_compatibility/java/com/sap/sdt/util/misc/BootStrapper.java#2 $";
    private int[] requiredJavaVersion = new int[]{1, 4, 2};
    private String className = "Main";
    private String methodName = "main";
    private Object[] arguments = null;
    private boolean staticMethod = true;

    public boolean start() {
        if (!JavaRuntime.isRequiredVersion(this.requiredJavaVersion)) {
            Locale.setDefault(Locale.ENGLISH);
            try {
                Class<?> lookAndFeelClass = Class.forName("com.sap.plaf.frog.FrogLookAndFeel");
                LookAndFeel lookAndFeel = (LookAndFeel)lookAndFeelClass.newInstance();
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception e) {
                // empty catch block
            }
            StringBuffer versionText = new StringBuffer(16);
            for (int i = 0; i < this.requiredJavaVersion.length; ++i) {
                if (i > 0) {
                    versionText.append('.');
                }
                versionText.append(this.requiredJavaVersion[i]);
            }
            String text = "Java Runtime version ";
            text = text + System.getProperty("java.version");
            text = text + " detected.";
            text = text + "\nThe GUI requires Java Runtime ";
            text = text + versionText.toString();
            text = text + " or later to run.";
            text = text + "\n\nInstall the required Java Runtime and start again.";
            JOptionPane.showMessageDialog(null, text, "GUI Start Error", 0);
            return false;
        }
        Class[] types = null;
        if (this.arguments != null && this.arguments.length > 0) {
            types = new Class[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                types[i] = this.arguments[i].getClass();
            }
        }
        try {
            Class<?> cls = Class.forName(this.className);
            Method method = cls.getMethod(this.methodName, types);
            Object obj = null;
            if (!this.staticMethod) {
                obj = cls.newInstance();
            }
            method.invoke(obj, this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setRequiredJavaVersion(int[] version) {
        if (version == null || version.length == 0) {
            throw new IllegalArgumentException("version must not be empty");
        }
        this.requiredJavaVersion = version;
    }

    public void setClassName(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("class name must not be empty");
        }
        this.className = className;
    }

    public void setMethodName(String methodName) {
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("method name must not be empty");
        }
        this.methodName = methodName;
        this.staticMethod = false;
    }

    public void setStaticMethodName(String methodName) {
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("method name must not be empty");
        }
        this.methodName = methodName;
        this.staticMethod = true;
    }

    public void setArguments(Object[] args) {
        this.arguments = args;
    }
}

