/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.UIManager;

public class Base64Codec {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/misc/Base64Codec.java#2 $";
    private static char[] alphabet;
    private static final byte[] codes;

    private Base64Codec() {
    }

    public static final char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static final byte[] decode(char[] data) {
        int tempLen = data.length;
        for (int ix = 0; ix < data.length; ++ix) {
            if (data[ix] <= '\u00ff' && codes[data[ix]] >= 0) continue;
            --tempLen;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            int value;
            int n = value = data[ix] > '\u00ff' ? -1 : codes[data[ix]];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        return out;
    }

    public static final char[] breakLines(char[] data) {
        char[] broken = new char[data.length + data.length / 80];
        int i = 0;
        int j = 0;
        int col = 0;
        while (i < data.length) {
            if (col == 80) {
                col = 0;
                broken[j++] = 10;
            }
            broken[j] = data[i];
            ++i;
            ++j;
            ++col;
        }
        return broken;
    }

    private static void setLookAndFeel() {
        boolean windows = System.getProperty("os.name").startsWith("Windows");
        Locale.setDefault(Locale.ENGLISH);
        try {
            String laf = UIManager.getLookAndFeel().getID();
            if (windows) {
                if (System.getProperty("swing.defaultlaf") == null || !laf.equals("Windows") && !laf.equals("Metal")) {
                    laf = "Windows";
                }
            } else {
                laf = "Metal";
            }
            if (laf.equals("Windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (laf.equals("Metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else {
                System.err.println("Error: unsupported look and feel '" + laf + "'");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Base64Codec.setLookAndFeel();
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            File inFile = chooser.getSelectedFile();
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
                byte[] data = new byte[200000];
                int n = in.read(data);
                if (n == data.length) {
                    System.err.println("Error: File must not be larger than " + data.length + " Bytes");
                    System.exit(-1);
                }
                in.close();
                byte[] data_short = new byte[n];
                System.arraycopy(data, 0, data_short, 0, data_short.length);
                char[] encoded = Base64Codec.encode(data_short);
                encoded = Base64Codec.breakLines(encoded);
                String outFileName = inFile.getName() + ".base64";
                File outFile = new File(inFile.getParentFile(), outFileName);
                BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
                out.write(encoded);
                out.close();
                System.out.println("File " + inFile.getName() + " successfully transformed to Base64 codec.");
            }
            catch (FileNotFoundException efnf) {
                System.err.println("File not found: " + efnf.getMessage());
                System.exit(-1);
            }
            catch (IOException eio) {
                System.err.println("I/O error: " + eio.getMessage());
                System.exit(-1);
            }
            System.exit(0);
        }
    }

    static {
        int i;
        alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64Codec.codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64Codec.codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64Codec.codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64Codec.codes[i] = (byte)(52 + i - 48);
        }
        Base64Codec.codes[43] = 62;
        Base64Codec.codes[47] = 63;
    }
}

