/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.misc;

import com.sap.sdt.util.misc.Alarm;
import com.sap.sdt.util.misc.AlarmObserverIF;
import com.sap.sdt.util.misc.Semaphore;
import java.util.Date;

public class AlarmClock
implements Runnable {
    private Alarm qHead = new Alarm(null, 0L, false);
    private Semaphore empty = new Semaphore(0);
    private Thread engine = new Thread((Runnable)this, "AlarmClock");

    public AlarmClock() {
        this.engine.start();
    }

    private void printPendingAlarms(String prefix) {
        int pos = 0;
        System.out.println(prefix);
        for (Alarm qNext = this.qHead.getSucc(); qNext != null; qNext = qNext.getSucc()) {
            System.out.println("  Pos " + pos++ + ": " + qNext.getDelay() + "/" + qNext.getAbsTime());
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alarm getAlarm() {
        Alarm qNext;
        this.empty.down();
        Semaphore semaphore = this.empty;
        synchronized (semaphore) {
            qNext = this.qHead.getSucc();
            this.qHead.setSucc(qNext.getSucc());
            qNext.setSucc(null);
            qNext.setQueued(false);
        }
        return qNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAlarm(Alarm alarm) {
        if (alarm.getQueued()) {
            throw new Error("Alarm request already queued");
        }
        alarm.setDiscarded(false);
        Semaphore semaphore = this.empty;
        synchronized (semaphore) {
            Alarm qNext = this.qHead;
            while (qNext.getSucc() != null && qNext.getSucc().isEarlier(alarm)) {
                qNext = qNext.getSucc();
            }
            alarm.setSucc(qNext.getSucc());
            qNext.setSucc(alarm);
            alarm.setQueued(true);
        }
        this.empty.up();
    }

    public void run() {
        while (true) {
            Alarm alarm = this.getAlarm();
            try {
                long sleepTime = alarm.getAbsTime() - new Date().getTime();
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (alarm.getDiscarded()) continue;
            alarm.notifyAlarmObserver();
            if (!alarm.getRecurring()) continue;
            this.createAlarm(alarm);
        }
    }

    public Alarm createAlarm(AlarmObserverIF observer, long delay) {
        return this.createAlarm(observer, delay, false);
    }

    public Alarm createAlarm(AlarmObserverIF observer, long delay, boolean recurring) {
        return this.createAlarm(new Alarm(observer, delay, recurring));
    }

    public Alarm createAlarm(Alarm alarm) {
        alarm.setAbsTime(new Date().getTime() + alarm.getDelay());
        this.putAlarm(alarm);
        return alarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAlarm(Alarm alarm) {
        Semaphore semaphore = this.empty;
        synchronized (semaphore) {
            alarm.setDiscarded(true);
        }
    }
}

