/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.map;

import com.sap.sdt.util.map.MultiStringMapException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;

public class MultiStringMap {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/map/MultiStringMap.java#2 $";
    private ArrayList alist;
    private KeyValue[] array = null;

    public MultiStringMap() {
        this.alist = new ArrayList();
    }

    public MultiStringMap(int initialCapacity) {
        this.alist = new ArrayList(initialCapacity);
    }

    public MultiStringMap(Collection coll) {
        this.alist = new ArrayList(coll);
    }

    public void put(String key, String value) {
        this.alist.add(new KeyValue(key, value));
    }

    public void close() {
        this.array = this.alist.toArray(new KeyValue[this.alist.size()]);
        this.alist = null;
        Arrays.sort(this.array);
    }

    public String getUnique(String key) throws MultiStringMapException {
        int k = Arrays.binarySearch(this.array, new KeyValue(key, null));
        if (k < 0) {
            return null;
        }
        if (k + 1 < this.array.length && key.equals(this.array[k + 1].getKey())) {
            throw new MultiStringMapException("key '" + key + "' not unique");
        }
        return this.array[k].getValue();
    }

    public Enumeration getMulti(String key) {
        int k = Arrays.binarySearch(this.array, new KeyValue(key, null));
        if (k < 0) {
            return null;
        }
        return new EnumString(k, key);
    }

    public Enumeration getMulti(char startchar) {
        int k = Arrays.binarySearch(this.array, new KeyValue(startchar + ":", null));
        if (k < 0) {
            k = -1 - k;
        }
        return new EnumString(k, startchar);
    }

    private class EnumString
    implements Enumeration {
        int curr;
        String key;
        char kchar;

        public EnumString(int curr, String key) {
            this.curr = curr;
            this.key = key;
            this.kchar = '\u0000';
        }

        public EnumString(int curr, char kchar) {
            this.curr = curr;
            this.key = null;
            this.kchar = kchar;
        }

        public boolean hasMoreElements() {
            if (this.curr >= MultiStringMap.this.array.length) {
                return false;
            }
            KeyValue next = MultiStringMap.this.array[this.curr];
            if (this.key != null) {
                return this.key.equals(next.getKey());
            }
            return next.getKey().charAt(0) == this.kchar;
        }

        public Object nextElement() {
            return MultiStringMap.this.array[this.curr++];
        }
    }

    public class KeyValue
    implements Comparable {
        String key;
        String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public int compareTo(Object o) {
            KeyValue other = (KeyValue)o;
            return this.key.compareTo(other.getKey());
        }
    }
}

