/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.map;

import com.sap.sdt.util.map.MapEntryNotFoundException;
import com.sap.sdt.util.map.StringInt;
import java.util.Arrays;
import java.util.Comparator;

public class MapStringInt {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/map/MapStringInt.java#3 $";
    private StringInt[] stringMap = null;
    private int[][] intMap = null;
    private int maxSize = -1;
    private int entryCnt = -1;
    private boolean closed = false;

    public MapStringInt(int size) {
        if (size <= 0) {
            this.stringMap = null;
            this.intMap = null;
        } else {
            this.stringMap = new StringInt[size];
            for (int inx = 0; inx < size; ++inx) {
                this.stringMap[inx] = null;
            }
        }
        this.entryCnt = 0;
        this.maxSize = size;
        this.closed = false;
    }

    public void add(String s, int i) {
        this.add(i, s);
    }

    public void add(int i, String s) {
        if (this.entryCnt >= this.maxSize) {
            this.enlarge();
        }
        this.closed = false;
        this.stringMap[this.entryCnt] = new StringInt(s, i);
        ++this.entryCnt;
    }

    public void close() {
        Arrays.sort(this.stringMap, 0, this.entryCnt);
        this.intMap = new int[this.entryCnt][2];
        for (int i = 0; i < this.entryCnt; ++i) {
            this.intMap[i][0] = this.stringMap[i].i;
            this.intMap[i][1] = i;
        }
        Arrays.sort(this.intMap, 0, this.entryCnt, new IntCmp());
        this.closed = true;
    }

    public boolean isContained(String s) {
        try {
            int i = this.getIntE(s);
            return true;
        }
        catch (MapEntryNotFoundException e) {
            return false;
        }
    }

    public boolean isContained(int i) {
        try {
            String s = this.getStringE(i);
            return true;
        }
        catch (MapEntryNotFoundException e) {
            return false;
        }
    }

    public int getIntE(String s) throws MapEntryNotFoundException {
        int inx;
        if (!this.closed) {
            this.close();
        }
        if ((inx = this.locateString(s)) < 0) {
            throw new MapEntryNotFoundException(s);
        }
        return this.stringMap[inx].i;
    }

    public String getStringE(int i) throws MapEntryNotFoundException {
        int inx;
        if (!this.closed) {
            this.close();
        }
        if ((inx = this.locateKey(i)) < 0) {
            throw new MapEntryNotFoundException(i);
        }
        return this.stringMap[this.intMap[inx][1]].s;
    }

    private void enlarge() {
        int inx = 0;
        int newMaxSize = this.maxSize <= 0 ? 100 : this.maxSize * 15 / 10 + 2;
        StringInt[] newStringMap = new StringInt[newMaxSize];
        for (inx = 0; inx < this.entryCnt; ++inx) {
            newStringMap[inx] = this.stringMap[inx];
        }
        for (inx = this.entryCnt; inx < newMaxSize; ++inx) {
            newStringMap[inx] = null;
        }
        this.stringMap = newStringMap;
        this.maxSize = newMaxSize;
    }

    private int locateKey(int key) {
        int lower = 0;
        int upper = this.entryCnt;
        while (lower < upper) {
            int m = lower + upper >> 1;
            if (this.intMap[m][0] < key) {
                lower = m + 1;
                continue;
            }
            upper = m;
        }
        if (lower < this.entryCnt && this.intMap[lower][0] == key) {
            return lower;
        }
        return -1 - lower;
    }

    private int locateString(String key) {
        int lower = 0;
        int upper = this.entryCnt;
        while (lower < upper) {
            int m = lower + upper >> 1;
            if (this.stringMap[m].compareTo(key) < 0) {
                lower = m + 1;
                continue;
            }
            upper = m;
        }
        if (lower < this.entryCnt && this.stringMap[lower].compareTo(key) == 0) {
            return lower;
        }
        return -1 - lower;
    }

    private static class IntCmp
    implements Comparator {
        private IntCmp() {
        }

        public int compare(Object a, Object b) {
            int[] ai = (int[])a;
            int[] bi = (int[])b;
            return ai[0] - bi[0];
        }
    }
}

